/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.locateExtremeValues;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class LocateExtremeValuesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String GRID = "GRID";
    public static final String POLYGONS = "POLYGONS";
    public static final String EXTREME_VALUE_TYPE = "EXTREME_VALUE_TYPE";
    private int m_iNX;
    private int m_iNY;
    private IVectorLayer m_Layer;
    private AnalysisExtent m_Extent;
    private IRasterLayer m_Window;
    private Coordinate m_Coordinate;
    private double m_dExtremeValue;
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Locate_max_values"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons"), 2, true);
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Grid"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Max_values"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        GeometryFactory gf = new GeometryFactory();
        this.m_Coordinate = new Coordinate();
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        String[] sNames = new String[]{this.m_Window.getName()};
        Class[] types = new Class[]{Double.class};
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 0, types, sNames);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iShapeCount = this.m_Layer.getShapesCount();
        this.m_Window.setFullExtent();
        this.m_Extent = this.m_Window.getWindowGridExtent();
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMin()), new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMax()), new Coordinate(this.m_Extent.getYMax(), this.m_Extent.getYMax()), new Coordinate(this.m_Extent.getXMax(), this.m_Extent.getYMin()), new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMin())};
        LinearRing ring = gf.createLinearRing(coords);
        Polygon extent = gf.createPolygon(ring, null);
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        IFeatureIterator iter = this.m_Layer.iterator();
        i = 0;
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            if (geom.intersects((Geometry)extent)) {
                this.m_dExtremeValue = Double.NEGATIVE_INFINITY;
                this.doPolygon(geom);
                Point pt = gf.createPoint(new Coordinate(this.m_Coordinate.x, this.m_Coordinate.y));
                this.m_Output.addFeature((Geometry)pt, new Object[]{new Double(this.m_dExtremeValue)});
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void doPolygon(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part);
        }
    }

    private void doPolygonPart(Geometry geom) {
        int xStop;
        Coordinate p = new Coordinate();
        boolean[] bCrossing = new boolean[this.m_iNX];
        Envelope extent = geom.getEnvelopeInternal();
        int xStart = (int)((extent.getMinX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) - 1;
        if (xStart < 0) {
            xStart = 0;
        }
        if ((xStop = (int)((extent.getMaxX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) + 1) >= this.m_iNX) {
            xStop = this.m_iNX - 1;
        }
        Coordinate[] points = geom.getCoordinates();
        int y = 0;
        double yPos = this.m_Extent.getYMax();
        while (y < this.m_iNY) {
            if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                Arrays.fill(bCrossing, false);
                Coordinate pLeft = new Coordinate(this.m_Extent.getXMin() - 1.0, yPos);
                Coordinate pRight = new Coordinate(this.m_Extent.getXMax() + 1.0, yPos);
                Coordinate pb = points[points.length - 1];
                for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                    Coordinate pa = pb;
                    pb = points[iPoint];
                    if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                    this.getCrossing(p, pa, pb, pLeft, pRight);
                    int ix = (int)((p.x - this.m_Extent.getXMin()) / this.m_Extent.getCellSize() + 1.0);
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= this.m_iNX) {
                        ix = this.m_iNX - 1;
                    }
                    bCrossing[ix] = !bCrossing[ix];
                }
                boolean bFill = false;
                for (int x = xStart; x <= xStop; ++x) {
                    double dValue;
                    if (bCrossing[x]) {
                        boolean bl = bFill = !bFill;
                    }
                    if (!bFill || this.m_Window.isNoDataValue(dValue = this.m_Window.getCellValueAsDouble(x, y)) || !(dValue > this.m_dExtremeValue)) continue;
                    this.m_dExtremeValue = dValue;
                    Point2D coord = this.m_Extent.getWorldCoordsFromGridCoords(x, y);
                    this.m_Coordinate.x = coord.getX();
                    this.m_Coordinate.y = coord.getY();
                }
            }
            ++y;
            yPos -= this.m_Extent.getCellSize();
        }
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }
}

