/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.heightOverChannelNetwork;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gridTools.closeGaps.CloseGapsAlgorithm;

public class HeightOverChannelNetworkAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String NETWORK = "NETWORK";
    public static final String HEIGHTOVER = "HEIGHTOVER";
    public static final String THRESHOLD = "THRESHOLD";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Network = null;
    private IRasterLayer m_Diff;
    private double m_dThreshold;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Network = this.m_Parameters.getParameterValueAsRasterLayer(NETWORK);
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
        this.m_Diff = this.getNewRasterLayer(HEIGHTOVER, Sextante.getText((String)"Elevation_over_channel_network"), 4);
        this.m_Diff.setNoDataValue(-1.0);
        AnalysisExtent extent = this.m_Diff.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Network.setWindowExtent(extent);
        this.m_Network.setInterpolationMethod(0);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        return this.interpolateSurfaceAndSubstract();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Elevation_over_channel_network"));
        this.setGroup(Sextante.getText((String)"Indices_and_other_hydrological_parameters"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(NETWORK, Sextante.getText((String)"Channel_network"), true);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Tension_threshold"), 0.1, 2);
            this.addOutputRasterLayer(HEIGHTOVER, Sextante.getText((String)"Elevation_over_channel_network"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean interpolateSurfaceAndSubstract() throws GeoAlgorithmExecutionException {
        double dValue;
        int x;
        int y;
        for (y = 0; y < this.m_iNY; ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                dValue = this.m_Network.getCellValueAsDouble(x, y);
                if (dValue != 0.0 && !this.m_Network.isNoDataValue(dValue)) {
                    dValue = this.m_DEM.getCellValueAsDouble(x, y);
                    this.m_Diff.setCellValue(x, y, dValue);
                    continue;
                }
                this.m_Diff.setNoData(x, y);
            }
        }
        CloseGapsAlgorithm alg = new CloseGapsAlgorithm();
        ParametersSet ps = alg.getParameters();
        ps.getParameter("INPUT").setParameterValue((Object)this.m_Diff);
        ps.getParameter(THRESHOLD).setParameterValue((Object)new Double(this.m_dThreshold));
        if (alg.execute(this.m_Task, this.m_OutputFactory)) {
            OutputObjectsSet output = alg.getOutputObjects();
            IRasterLayer networkHeight = (IRasterLayer)output.getOutput("RESULT").getOutputObject();
            networkHeight.open();
            for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
                for (x = 0; x < this.m_iNX; ++x) {
                    dValue = this.m_DEM.getCellValueAsDouble(x, y);
                    double dValue2 = networkHeight.getCellValueAsDouble(x, y);
                    if (this.m_DEM.isNoDataValue(dValue) || networkHeight.isNoDataValue(dValue2)) {
                        this.m_Diff.setNoData(x, y);
                        continue;
                    }
                    this.m_Diff.setCellValue(x, y, dValue - dValue2);
                }
            }
            networkHeight.close();
            return !this.m_Task.isCanceled();
        }
        return false;
    }
}

