/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.isocrones;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;

public class IsocronesAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String NETWORK = "NETWORK";
    public static final String OUTLET = "OUTLET";
    public static final String TIME = "TIME";
    public static final String RATIO = "RATIO";
    private int m_iNX;
    private int m_iNY;
    private double m_dSpeed;
    private double m_dRatio;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Network = null;
    private IRasterLayer m_TimeOut;
    private GridCell m_Outlet;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Network = this.m_Parameters.getParameterValueAsRasterLayer(NETWORK);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(OUTLET);
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)this.m_DEM);
        this.m_DEM.setWindowExtent(gridExtent);
        this.m_TimeOut = this.getNewRasterLayer(TIME, Sextante.getText((String)"Time_to_outlet__h"), 4, gridExtent);
        this.m_TimeOut.assign(0.0);
        this.m_Outlet = gridExtent.getGridCoordsFromWorldCoords(pt);
        if (this.m_Network != null) {
            this.m_Network.setWindowExtent(gridExtent);
        }
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.m_dSpeed = 1.0;
        this.m_dRatio = 1.0;
        this.calculateTimeOfConcentration();
        this.m_dRatio = this.m_Parameters.getParameterValueAsDouble(RATIO);
        this.calculateTimeOut();
        this.m_TimeOut.setNoDataValue(0.0);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Time_to_outlet"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(NETWORK, Sextante.getText((String)"Channel_network"), false);
            this.m_Parameters.addNumericalValue(RATIO, Sextante.getText((String)"speed_ratio__channel_-_overland"), 10.0, 2);
            this.m_Parameters.addPoint(OUTLET, Sextante.getText((String)"Outlet_point"));
            this.addOutputRasterLayer(TIME, Sextante.getText((String)"Time_to_outlet"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateTimeOfConcentration() {
        GridCell highestCell = new GridCell(0, 0, Double.NEGATIVE_INFINITY);
        this.writeTimeOut(this.m_Outlet.getX(), this.m_Outlet.getY(), this.m_Outlet.getX(), this.m_Outlet.getY());
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_TimeOut.getCellValueAsDouble(x, y);
                if (this.m_TimeOut.isNoDataValue(dValue) || !(dValue > highestCell.getValue())) continue;
                highestCell.setX(x);
                highestCell.setY(y);
                highestCell.setValue(dValue);
            }
        }
        double dH1 = this.m_DEM.getCellValueAsDouble(this.m_Outlet.getX(), this.m_Outlet.getY());
        double dH2 = this.m_DEM.getCellValueAsDouble(highestCell.getX(), highestCell.getY());
        double dConcTime = Math.pow(0.87 * Math.pow(highestCell.getValue() / 1000.0, 3.0) / (dH2 - dH1), 0.385);
        this.m_dSpeed = highestCell.getValue() / dConcTime;
    }

    private void calculateTimeOut() {
        this.m_TimeOut.assign(0.0);
        this.writeTimeOut(this.m_Outlet.getX(), this.m_Outlet.getY(), this.m_Outlet.getX(), this.m_Outlet.getY());
    }

    private void writeTimeOut(int iX1, int iY1, int iX2, int iY2) {
        double dDist = 1.0;
        if (this.m_Task.isCanceled()) {
            return;
        }
        double dValue = this.m_DEM.getCellValueAsDouble(iX1, iY1);
        if (!this.m_DEM.isNoDataValue(dValue)) {
            dDist = iX1 == iX2 && iY1 == iY2 ? 0.0 : (Math.abs(iX1 - iX2 + iY1 - iY2) == 1 ? this.m_DEM.getDistToNeighborInDir(0) : this.m_DEM.getDistToNeighborInDir(1));
            double dTime = dDist / this.m_dSpeed;
            if (this.m_Network != null && (this.m_Network.isNoDataValue(dValue = this.m_Network.getCellValueAsDouble(iX1, iY1)) || dValue == 0.0)) {
                dTime *= this.m_dRatio;
            }
            this.m_TimeOut.setCellValue(iX1, iY1, dTime += this.m_TimeOut.getCellValueAsDouble(iX2, iY2));
            for (int i = 0; i < 8; ++i) {
                int iDirection;
                int ix = iX1 + m_iOffsetX[i];
                int iy = iY1 + m_iOffsetY[i];
                dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (this.m_DEM.isNoDataValue(dValue) || (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy)) < 0 || (i + 4) % 8 != iDirection) continue;
                this.writeTimeOut(ix, iy, iX1, iY1);
            }
        }
    }
}

