/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.setLinesDirectionsWithDEM;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class SetLinesDirectionsWithDEMAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LINES = "LINES";
    public static final String DEM = "DEM";
    private IVectorLayer m_Output;
    private ArrayList m_Lines;
    private IRasterLayer m_DEM;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Change_line_direction"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Lines"), 1, LINES);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, lines.getFieldTypes(), lines.getFieldNames());
        int i = 0;
        int iShapeCount = lines.getShapesCount();
        IFeatureIterator iter = lines.iterator();
        GeometryFactory gf = new GeometryFactory();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            this.m_Lines = new ArrayList();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry line = geom.getGeometryN(j);
                this.addLine(line);
            }
            LineString[] lineStrings = new LineString[this.m_Lines.size()];
            for (int j = 0; j < lineStrings.length; ++j) {
                lineStrings[j] = (LineString)this.m_Lines.get(j);
            }
            this.m_Output.addFeature((Geometry)gf.createMultiLineString(lineStrings), feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void addLine(Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        double z = this.m_DEM.getValueAt(coords[0].x, coords[0].y);
        double z2 = this.m_DEM.getValueAt(coords[coords.length - 1].x, coords[coords.length - 1].y);
        if (z2 > z) {
            Coordinate[] newCoords = new Coordinate[coords.length];
            for (int i = 0; i < coords.length; ++i) {
                newCoords[i] = coords[coords.length - i - 1];
            }
            GeometryFactory gf = new GeometryFactory();
            this.m_Lines.add(gf.createLineString(newCoords));
        } else {
            this.m_Lines.add(line);
        }
    }
}

