/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.slopeLength;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.Arrays;

public class SlopeLengthAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String USETHRESHOLD = "USETHRESHOLD";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String SLOPELENGTH = "SLOPELENGTH";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_SlopeLength;
    private IRasterLayer m_Slope;
    private double m_dThreshold;
    private boolean m_bUseThreshold;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_bUseThreshold = this.m_Parameters.getParameterValueAsBoolean(USETHRESHOLD);
        this.m_dThreshold = Math.abs(this.m_Parameters.getParameterValueAsDouble(THRESHOLD));
        this.m_SlopeLength = this.getNewRasterLayer(SLOPELENGTH, Sextante.getText((String)"Slope_length"), 4);
        this.m_SlopeLength.assign(0.0);
        AnalysisExtent extent = this.m_SlopeLength.getWindowGridExtent();
        this.m_Slope = this.getTempRasterLayer(4, extent);
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        if (this.m_bUseThreshold) {
            this.createSlopeLayer();
        }
        GridCell[] cells = this.getSortedArrayOfCells(this.m_DEM);
        int iCells = cells.length;
        for (int i = iCells - 1; i > -1 && this.setProgress(iCells - i, iCells); --i) {
            this.setLength(cells[i].getX(), cells[i].getY());
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Slope_length"));
        this.setGroup(Sextante.getText((String)"Indices_and_other_hydrological_parameters"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Slope_change_threshold"), 0.5, 2);
            this.m_Parameters.addBoolean(USETHRESHOLD, Sextante.getText((String)"Use_threshold"), true);
            this.addOutputRasterLayer(SLOPELENGTH, Sextante.getText((String)"Slope_length"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void createSlopeLayer() {
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.m_Slope.setCellValue(x, y, this.m_DEM.getSlope(x, y));
            }
        }
    }

    private void setLength(int x, int y) {
        int i;
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(dValue) && (i = this.m_DEM.getDirToNextDownslopeCell(x, y)) >= 0) {
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (!this.m_DEM.isNoDataValue(dValue)) {
                if (this.m_bUseThreshold) {
                    double dSlope = this.m_Slope.getCellValueAsDouble(x, y);
                    double dSlope2 = this.m_Slope.getCellValueAsDouble(ix, iy);
                    double dLength = Math.abs(dSlope2) > this.m_dThreshold * Math.abs(dSlope) ? this.m_SlopeLength.getCellValueAsDouble(x, y) + this.m_DEM.getDistToNeighborInDir(i) : this.m_DEM.getDistToNeighborInDir(i);
                    if (dLength > this.m_SlopeLength.getCellValueAsDouble(ix, iy)) {
                        this.m_SlopeLength.setCellValue(ix, iy, dLength);
                    }
                } else {
                    double dLength = this.m_SlopeLength.getCellValueAsDouble(x, y) + this.m_DEM.getDistToNeighborInDir(i);
                    if (dLength > this.m_SlopeLength.getCellValueAsDouble(ix, iy)) {
                        this.m_SlopeLength.setCellValue(ix, iy, dLength);
                    }
                }
            }
        } else {
            this.m_SlopeLength.setNoData(x, y);
        }
    }

    public GridCell[] getSortedArrayOfCells(IRasterLayer layer) {
        int iNX = layer.getNX();
        int iCells = layer.getNX() * layer.getNY();
        Object[] cells = new GridCell[iCells];
        for (int i = 0; i < iCells; ++i) {
            int iX = i % iNX;
            int iY = i / iNX;
            GridCell cell = new GridCell(iX, iY, layer.getCellValueAsDouble(iX, iY));
            cells[i] = cell;
        }
        Arrays.sort(cells);
        return cells;
    }
}

