/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.strahlerOrder;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class StrahlerOrderAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Strahler;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Strahler = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Strahler_Order"), 3);
        this.m_Strahler.assign(0.0);
        AnalysisExtent extent = this.m_Strahler.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.getStrahlerOrder(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Strahler_Order"));
        this.setGroup(Sextante.getText((String)"Indices_and_other_hydrological_parameters"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Strahler_Order"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void getStrahlerOrder(int x, int y) {
        int iMaxOrder = 1;
        int iOrder = 1;
        int iMaxOrderCells = 0;
        if (this.m_DEM.isNoDataValue(this.m_DEM.getCellValueAsDouble(x, y))) {
            return;
        }
        if (this.m_Strahler.getCellValueAsInt(x, y) == 0) {
            this.m_Strahler.setCellValue(x, y, (double)iMaxOrder);
            for (int i = 0; i < 8; ++i) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                int iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy);
                if (iDirection != (i + 4) % 8) continue;
                this.getStrahlerOrder(ix, iy);
                iOrder = this.m_Strahler.getCellValueAsInt(ix, iy);
                if (iOrder > iMaxOrder) {
                    iMaxOrder = iOrder;
                    iMaxOrderCells = 1;
                    continue;
                }
                if (iOrder != iMaxOrder) continue;
                ++iMaxOrderCells;
            }
            if (iMaxOrderCells > 1) {
                ++iMaxOrder;
            }
            this.m_Strahler.setCellValue(x, y, (double)iMaxOrder);
        }
    }
}

