/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.upslopeAreaFromPoint;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;

public class UpslopeAreaFromPointAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String OUTLET = "OUTLET";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Watershed;
    private GridCell m_Outlet;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(OUTLET);
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)this.m_DEM);
        this.m_DEM.setFullExtent();
        this.m_Watershed = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Upslope_area"), 0, gridExtent);
        this.m_Watershed.assign(0.0);
        this.m_Outlet = gridExtent.getGridCoordsFromWorldCoords(pt);
        this.calculateWatershed();
        this.m_Watershed.setNoDataValue(0.0);
        return true;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Upslope_area_from_a_single_point"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addPoint(OUTLET, Sextante.getText((String)"Outlet_point"));
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Upslope_area"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateWatershed() {
        this.writeCell(this.m_Outlet.getX(), this.m_Outlet.getY());
    }

    private void writeCell(int iX, int iY) {
        double dValue = this.m_DEM.getCellValueAsDouble(iX, iY);
        if (!this.m_DEM.isNoDataValue(dValue)) {
            this.m_Watershed.setCellValue(iX, iY, 1.0);
            for (int i = 0; i < 8; ++i) {
                int iDirection;
                int ix = iX + m_iOffsetX[i];
                int iy = iY + m_iOffsetY[i];
                dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (this.m_DEM.isNoDataValue(dValue) || (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy, false)) < 0 || (i + 4) % 8 != iDirection) continue;
                this.writeCell(ix, iy);
            }
        }
    }
}

