/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.calibrateRegression;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.regression.Regression;

public class CalibrateRegressionAlgorithm
extends GeoAlgorithm {
    public static final String CALIBRATED = "CALIBRATED";
    public static final String INPUT = "INPUT";
    public static final String REF = "REF";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Calibrate_an_image__regression"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setGroup(Sextante.getText((String)"Image_processing"));
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Image_to_calibrate"), true);
            this.m_Parameters.addInputRasterLayer(REF, Sextante.getText((String)"Reference_image"), false);
            this.addOutputRasterLayer(CALIBRATED, Sextante.getText((String)"Calibrated_image"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dCellValue;
        int x;
        int y;
        Regression regression = new Regression();
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        IRasterLayer ref = this.m_Parameters.getParameterValueAsRasterLayer(REF);
        input.setFullExtent();
        ref.setWindowExtent(input.getWindowGridExtent());
        IRasterLayer output = this.getNewRasterLayer(CALIBRATED, Sextante.getText((String)"Calibrated_image"), input.getDataType(), input.getWindowGridExtent());
        if (ref.getDataType() == 3 || ref.getDataType() == 2) {
            ref.setInterpolationMethod(0);
        }
        int iNX = input.getNX();
        int iNY = input.getNY();
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                dCellValue = input.getCellValueAsDouble(x, y);
                double dCellValue2 = ref.getCellValueAsDouble(x, y);
                if (input.isNoDataValue(dCellValue) || ref.isNoDataValue(dCellValue2)) continue;
                regression.addValue(dCellValue, dCellValue2);
            }
        }
        regression.calculate();
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                dCellValue = input.getCellValueAsDouble(x, y);
                if (input.isNoDataValue(dCellValue)) {
                    output.setNoData(x, y);
                    continue;
                }
                output.setCellValue(x, y, regression.getY(dCellValue));
            }
        }
        return !this.m_Task.isCanceled();
    }
}

