/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.rgb2his;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class RGB2HISAlgorithm
extends GeoAlgorithm {
    public static final String LAYERR = "LAYERR";
    public static final String LAYERB = "LAYERB";
    public static final String LAYERG = "LAYERG";
    public static final String BANDR = "BANDR";
    public static final String BANDG = "BANDG";
    public static final String BANDB = "BANDB";
    public static final String H = "H";
    public static final String I = "I";
    public static final String S = "S";

    public void defineCharacteristics() {
        this.setName("RGB -> HIS");
        this.setGroup(Sextante.getText((String)"Image_processing"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYERR, Sextante.getText((String)"R_layer"), true);
            this.m_Parameters.addBand(BANDR, Sextante.getText((String)"R_band"), LAYERR);
            this.m_Parameters.addInputRasterLayer(LAYERG, Sextante.getText((String)"G_layer"), true);
            this.m_Parameters.addBand(BANDG, Sextante.getText((String)"G_band"), LAYERG);
            this.m_Parameters.addInputRasterLayer(LAYERB, Sextante.getText((String)"B_layer"), true);
            this.m_Parameters.addBand(BANDB, Sextante.getText((String)"B_band"), LAYERB);
            this.addOutputRasterLayer(H, H);
            this.addOutputRasterLayer(I, I);
            this.addOutputRasterLayer(S, S);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer rLayer = this.m_Parameters.getParameterValueAsRasterLayer(LAYERR);
        IRasterLayer gLayer = this.m_Parameters.getParameterValueAsRasterLayer(LAYERG);
        IRasterLayer bLayer = this.m_Parameters.getParameterValueAsRasterLayer(LAYERB);
        int rBand = this.m_Parameters.getParameterValueAsInt(BANDR);
        int gBand = this.m_Parameters.getParameterValueAsInt(BANDG);
        int bBand = this.m_Parameters.getParameterValueAsInt(BANDB);
        IRasterLayer hLayer = this.getNewRasterLayer(H, H, 4);
        IRasterLayer iLayer = this.getNewRasterLayer(I, I, 0);
        IRasterLayer sLayer = this.getNewRasterLayer(S, S, 4);
        AnalysisExtent gridExtent = hLayer.getWindowGridExtent();
        rLayer.setWindowExtent(gridExtent);
        gLayer.setWindowExtent(gridExtent);
        bLayer.setWindowExtent(gridExtent);
        int iNX = gridExtent.getNX();
        int iNY = gridExtent.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                byte r = rLayer.getCellValueAsByte(x, y, rBand);
                byte g = gLayer.getCellValueAsByte(x, y, gBand);
                byte b = bLayer.getCellValueAsByte(x, y, bBand);
                if (rLayer.isNoDataValue((double)r) || gLayer.isNoDataValue((double)g) || bLayer.isNoDataValue((double)b)) {
                    hLayer.setNoData(x, y);
                    sLayer.setNoData(x, y);
                    iLayer.setNoData(x, y);
                    continue;
                }
                double h = (double)(r - g + (r - b)) * 0.5 / Math.sqrt((double)((r - g) * (r - g) + (r - b) * (g - b)) + 1.0E-10);
                h = Math.acos(h);
                if (Double.isNaN(h = h / Math.PI * 180.0)) {
                    h = 0.0;
                }
                if (b > g) {
                    h = 360.0 - h;
                }
                byte i = (byte)((double)(r + g + b) / Math.sqrt(3.0));
                double s = r == g && g == b ? 0.0 : (double)((float)(1.0 - Math.sqrt(3.0) / (double)i * (double)Math.min(Math.min(r, g), b)));
                hLayer.setCellValue(x, y, h);
                iLayer.setCellValue(x, y, (double)i);
                sLayer.setCellValue(x, y, s);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

