/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.locate.locateAllocateB;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class LocateAllocateBAlgorithm
extends GeoAlgorithm {
    public static final int EUCLIDEAN = 0;
    public static final int MINSUM = 0;
    public static final int CONSTRAINEDMINSUM = 1;
    public static final int MINSTDDEV = 2;
    public static final int MINIMAX = 3;
    public static final int MAXCOV = 4;
    public static final int MAXSUM = 5;
    public static final int MINCOV = 6;
    public static final String MAXDIST = "MAXDIST";
    public static final String METHOD = "METHOD";
    public static final String NEWLOCATIONS = "NEWLOCATIONS";
    public static final String CANDIDATES = "CANDIDATES";
    public static final String OFFER = "OFFER";
    public static final String FIELDDEMAND = "FIELDDEMAND";
    public static final String DEMAND = "DEMAND";
    public static final String DEMAND_OFFER_DISTANCE_TABLE = "DEMAND_OFFER_DISTANCE_TABLE";
    public static final String DEMAND_CANDIDATES_DISTANCE_TABLE = "DEMAND_CANDIDATES_DISTANCE_TABLE";
    public static final String SPIDER = "SPIDER";
    public static final String RESULT = "RESULT";
    private static final int ITERATIONS = 100;
    private ArrayList m_Demand;
    private ArrayList m_Candidates;
    private ArrayList m_Offer;
    private double[][] m_dDist;
    private double m_dMaxDist;
    private double m_dObjective;
    private double m_dBestObjective;
    private int m_iNewLocations;
    private int[] m_iSolution;
    private int[] m_iBestSolution;
    private int m_iOffer;
    private int m_iTotalOffer;
    private int m_iMethod;
    private int m_iDemandField;
    private IVectorLayer m_DemandLayer;
    private IVectorLayer m_OfferLayer;
    private IVectorLayer m_CandidatesLayer;
    private ITable m_DemandOfferDistanceTable;
    private ITable m_DemandCandidatesDistanceTable;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Minimum_sum"), Sextante.getText((String)"Minimum_sum_with_restrictions"), Sextante.getText((String)"Minimum_standard_deviation"), Sextante.getText((String)"Minimize_maximum_distance"), Sextante.getText((String)"Maximum_coverage"), Sextante.getText((String)"Maximum_sum"), Sextante.getText((String)"Minimum_coverage")};
        this.setName(Sextante.getText((String)"Location-allocation_table_distance"));
        this.setGroup(Sextante.getText((String)"Location-allocation"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputVectorLayer(DEMAND, Sextante.getText((String)"Demand_points"), 0, true);
            this.m_Parameters.addTableField(FIELDDEMAND, Sextante.getText((String)"Field"), DEMAND);
            this.m_Parameters.addInputVectorLayer(OFFER, Sextante.getText((String)"Preexistent_resources"), 0, false);
            this.m_Parameters.addInputVectorLayer(CANDIDATES, Sextante.getText((String)"Candidate_points"), 0, true);
            this.m_Parameters.addInputTable(DEMAND_OFFER_DISTANCE_TABLE, Sextante.getText((String)"Demand_offer_distance_table"), true);
            this.m_Parameters.addInputTable(DEMAND_CANDIDATES_DISTANCE_TABLE, Sextante.getText((String)"Demand_candidates_distance_table"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(NEWLOCATIONS, Sextante.getText((String)"Number_of_resources_to_allocate"), 1, 1.0, 1.0, 2.147483647E9);
            this.m_Parameters.addNumericalValue(MAXDIST, Sextante.getText((String)"Maximum_distance"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(SPIDER, Sextante.getText((String)"Connections"), 1);
            this.addOutputText(RESULT, Sextante.getText((String)"Statistics"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DemandCandidatesDistanceTable = this.m_Parameters.getParameterValueAsTable(DEMAND_CANDIDATES_DISTANCE_TABLE);
        this.m_DemandOfferDistanceTable = this.m_Parameters.getParameterValueAsTable(DEMAND_OFFER_DISTANCE_TABLE);
        this.m_DemandLayer = this.m_Parameters.getParameterValueAsVectorLayer(DEMAND);
        this.m_iDemandField = this.m_Parameters.getParameterValueAsInt(FIELDDEMAND);
        this.m_OfferLayer = this.m_Parameters.getParameterValueAsVectorLayer(OFFER);
        this.m_CandidatesLayer = this.m_Parameters.getParameterValueAsVectorLayer(CANDIDATES);
        this.m_iNewLocations = this.m_Parameters.getParameterValueAsInt(NEWLOCATIONS);
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_dMaxDist = this.m_Parameters.getParameterValueAsDouble(MAXDIST);
        if (this.m_iNewLocations == 0) {
            return false;
        }
        this.extractPoints();
        this.calculateDistanceMatrix();
        this.m_dBestObjective = Double.MAX_VALUE;
        for (int i = 0; i < 100 && this.setProgress(i, 100); ++i) {
            this.setProgressText(Sextante.getText((String)"Iteration") + " " + Integer.toString(i) + "/" + Integer.toString(100));
            this.runTeitzBart();
            if (!(this.m_dObjective < this.m_dBestObjective)) continue;
            this.m_dBestObjective = this.m_dObjective;
            this.m_iBestSolution = this.m_iSolution;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        if (this.m_iBestSolution != null) {
            this.createResults();
        }
        return true;
    }

    private void extractPoints() throws GeoAlgorithmExecutionException {
        Coordinate coord;
        IFeature feature;
        this.m_Demand = new ArrayList();
        this.m_Offer = new ArrayList();
        this.m_Candidates = new ArrayList();
        IFeatureIterator iter = this.m_DemandLayer.iterator();
        while (iter.hasNext()) {
            double dWeight;
            feature = iter.next();
            coord = feature.getGeometry().getCoordinate();
            try {
                dWeight = Double.parseDouble(feature.getRecord().getValue(this.m_iDemandField).toString());
            }
            catch (Exception e) {
                dWeight = 1.0;
            }
            this.m_Demand.add(new DemandPoint(coord.x, coord.y, dWeight));
        }
        iter.close();
        iter = this.m_CandidatesLayer.iterator();
        while (iter.hasNext()) {
            feature = iter.next();
            coord = feature.getGeometry().getCoordinate();
            this.m_Candidates.add(coord);
        }
        iter.close();
        if (this.m_OfferLayer != null) {
            iter = this.m_OfferLayer.iterator();
            while (iter.hasNext()) {
                feature = iter.next();
                coord = feature.getGeometry().getCoordinate();
                this.m_Offer.add(coord);
            }
            iter.close();
        }
        if (this.m_Candidates.size() < this.m_iNewLocations || this.m_Demand.size() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Invalid_or_insufficient_data"));
        }
    }

    private void calculateDistanceMatrix() throws GeoAlgorithmExecutionException {
        String sValue;
        int j;
        IRecord record;
        this.m_iOffer = this.m_Offer.size();
        this.m_iTotalOffer = this.m_Offer.size() + this.m_Candidates.size();
        this.m_dDist = new double[this.m_Demand.size()][this.m_iTotalOffer];
        IRecordsetIterator iter = this.m_DemandOfferDistanceTable.iterator();
        int iDemand = 0;
        while (iter.hasNext()) {
            record = iter.next();
            for (j = 0; j < this.m_iOffer; ++j) {
                sValue = record.getValue(j).toString();
                try {
                    this.m_dDist[iDemand][j] = Double.parseDouble(sValue);
                }
                catch (Exception e) {
                    throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_data_in_table"));
                }
                ++iDemand;
            }
        }
        iter.close();
        iter = this.m_DemandCandidatesDistanceTable.iterator();
        iDemand = 0;
        while (iter.hasNext()) {
            record = iter.next();
            for (j = 0; j < this.m_Candidates.size(); ++j) {
                sValue = record.getValue(j).toString();
                try {
                    this.m_dDist[iDemand][j + this.m_iOffer] = Double.parseDouble(sValue);
                }
                catch (Exception e) {
                    throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_data_in_table"));
                }
                ++iDemand;
            }
        }
        iter.close();
    }

    private void runTeitzBart() {
        boolean bHasImproved;
        int i;
        int iAlternative = 0;
        int iValueToChange = 0;
        this.m_iSolution = new int[this.m_iNewLocations];
        for (i = 0; i < this.m_iSolution.length; ++i) {
            this.m_iSolution[i] = i;
        }
        do {
            bHasImproved = false;
            double dMin = this.getObjectiveFunctionValue();
            int iCount = 0;
            int iRandCount = (int)Math.floor(Math.random() * (double)(this.m_Candidates.size() - this.m_iSolution.length));
            for (i = 0; i < this.m_Candidates.size(); ++i) {
                boolean bIsSelected = false;
                for (int j = 0; j < this.m_iSolution.length; ++j) {
                    if (this.m_iSolution[j] != i) continue;
                    bIsSelected = true;
                    break;
                }
                if (bIsSelected) continue;
                if (iRandCount == iCount) {
                    iAlternative = i;
                    break;
                }
                ++iCount;
            }
            for (i = 0; i < this.m_iSolution.length; ++i) {
                int iOldValue = this.m_iSolution[i];
                this.m_iSolution[i] = iAlternative;
                this.m_dObjective = this.getObjectiveFunctionValue();
                if (this.m_dObjective < dMin) {
                    bHasImproved = true;
                    dMin = this.m_dObjective;
                    iValueToChange = i;
                }
                this.m_iSolution[i] = iOldValue;
            }
            if (!bHasImproved) continue;
            this.m_iSolution[iValueToChange] = iAlternative;
        } while (bHasImproved);
    }

    private double getObjectiveFunctionValue() {
        switch (this.m_iMethod) {
            default: {
                return this.getObjectiveFunctionValueMinSum();
            }
            case 1: {
                return this.getObjectiveFunctionValueConstrainedMinSum();
            }
            case 2: {
                return this.getObjectiveFunctionValueMinStdDev();
            }
            case 5: {
                return -this.getObjectiveFunctionValueMinSum();
            }
            case 4: {
                return this.getObjectiveFunctionValueMaxCov();
            }
            case 6: {
                return -this.getObjectiveFunctionValueMaxCov();
            }
            case 3: 
        }
        return this.getObjectiveFunctionValueMinMaxDistance();
    }

    private double getObjectiveFunctionValueMinStdDev() {
        double dSum = 0.0;
        double dVar = 0.0;
        for (int i = 0; i < this.m_Demand.size(); ++i) {
            int j;
            double dMin = Double.MAX_VALUE;
            for (j = 0; j < this.m_iOffer; ++j) {
                if (!(this.m_dDist[i][j] < dMin)) continue;
                dMin = this.m_dDist[i][j];
            }
            for (j = 0; j < this.m_iSolution.length; ++j) {
                int iPt = this.m_iSolution[j];
                if (!(this.m_dDist[i][iPt + this.m_iOffer] < dMin)) continue;
                dMin = this.m_dDist[i][iPt + this.m_iOffer];
            }
            dSum += dMin;
            dVar += dMin * dMin;
        }
        dVar = dVar / (double)this.m_Demand.size() - (dSum /= (double)this.m_Demand.size()) * dSum;
        return dVar;
    }

    private double getObjectiveFunctionValueConstrainedMinSum() {
        double dValue = 0.0;
        for (int i = 0; i < this.m_Demand.size(); ++i) {
            int j;
            double dMin = Double.MAX_VALUE;
            for (j = 0; j < this.m_iOffer; ++j) {
                if (!(this.m_dDist[i][j] < dMin)) continue;
                dMin = this.m_dDist[i][j];
            }
            for (j = 0; j < this.m_iSolution.length; ++j) {
                int iPt = this.m_iSolution[j];
                if (!(this.m_dDist[i][iPt + this.m_iOffer] < dMin)) continue;
                dMin = this.m_dDist[i][iPt + this.m_iOffer];
            }
            if (dMin < this.m_dMaxDist) {
                DemandPoint dpt = (DemandPoint)this.m_Demand.get(i);
                dValue += dMin * dpt.weight;
                continue;
            }
            dValue = Double.POSITIVE_INFINITY;
        }
        return dValue;
    }

    private double getObjectiveFunctionValueMaxCov() {
        double dValue = 0.0;
        for (int i = 0; i < this.m_Demand.size(); ++i) {
            int j;
            DemandPoint dpt = (DemandPoint)this.m_Demand.get(i);
            double dDemand = dpt.weight;
            for (j = 0; j < this.m_iOffer; ++j) {
                if (!(this.m_dDist[i][j] < this.m_dMaxDist)) continue;
                dDemand = 0.0;
                break;
            }
            if (dDemand != 0.0) {
                for (j = 0; j < this.m_iSolution.length; ++j) {
                    int iPt = this.m_iSolution[j];
                    if (!(this.m_dDist[i][iPt + this.m_iOffer] < this.m_dMaxDist)) continue;
                    dDemand = 0.0;
                    break;
                }
            }
            dValue += dDemand;
        }
        return dValue;
    }

    private double getObjectiveFunctionValueMinSum() {
        double dValue = 0.0;
        for (int i = 0; i < this.m_Demand.size(); ++i) {
            int j;
            double dMin = Double.MAX_VALUE;
            for (j = 0; j < this.m_iOffer; ++j) {
                if (!(this.m_dDist[i][j] < dMin)) continue;
                dMin = this.m_dDist[i][j];
            }
            for (j = 0; j < this.m_iSolution.length; ++j) {
                int iPt = this.m_iSolution[j];
                if (!(this.m_dDist[i][iPt + this.m_iOffer] < dMin)) continue;
                dMin = this.m_dDist[i][iPt + this.m_iOffer];
            }
            DemandPoint dpt = (DemandPoint)this.m_Demand.get(i);
            dValue += dMin * dpt.weight;
        }
        return dValue;
    }

    private double getObjectiveFunctionValueMinMaxDistance() {
        double dMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_Demand.size(); ++i) {
            int j;
            double dMin = Double.MAX_VALUE;
            for (j = 0; j < this.m_iOffer; ++j) {
                if (!(this.m_dDist[i][j] < dMin)) continue;
                dMin = this.m_dDist[i][j];
            }
            for (j = 0; j < this.m_iSolution.length; ++j) {
                int iPt = this.m_iSolution[j];
                if (!(this.m_dDist[i][iPt + this.m_iOffer] < dMin)) continue;
                dMin = this.m_dDist[i][iPt + this.m_iOffer];
            }
            if (!(dMax < dMin)) continue;
            dMax = dMin;
        }
        return dMax;
    }

    private void createResults() throws GeoAlgorithmExecutionException {
        int iPt;
        int i;
        int iID = 1;
        Coordinate pt = null;
        Coordinate[] coords = new Coordinate[2];
        Object[] values = new Object[8];
        String sOfferName = null;
        String[] sNames = new String[]{Sextante.getText((String)"ID"), Sextante.getText((String)"Demand_point"), Sextante.getText((String)"X_demand"), Sextante.getText((String)"Y_demand"), Sextante.getText((String)"Resource"), Sextante.getText((String)"X_resource"), Sextante.getText((String)"Y_resource"), Sextante.getText((String)"Distance")};
        Class[] types = new Class[]{Integer.class, String.class, Double.class, Double.class, String.class, Double.class, Double.class, Double.class};
        SimpleStats stats = new SimpleStats();
        IVectorLayer spiderWebLayer = this.getNewVectorLayer(SPIDER, Sextante.getText((String)"Conexions"), 1, types, sNames);
        IVectorLayer newPointsLayer = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Selected_points"), 0, new Class[]{Integer.class}, new String[]{"ID"});
        GeometryFactory gf = new GeometryFactory();
        for (i = 0; i < this.m_iBestSolution.length; ++i) {
            iPt = this.m_iBestSolution[i];
            pt = (Coordinate)this.m_Candidates.get(iPt);
            newPointsLayer.addFeature((Geometry)gf.createPoint(pt), new Object[]{new Integer(i)});
        }
        for (i = 0; i < this.m_Demand.size(); ++i) {
            int j;
            DemandPoint dpt = (DemandPoint)this.m_Demand.get(i);
            double dMin = Double.MAX_VALUE;
            for (j = 0; j < this.m_iOffer; ++j) {
                if (!(this.m_dDist[i][j] < dMin)) continue;
                dMin = this.m_dDist[i][j];
                pt = (Coordinate)this.m_Offer.get(j);
                sOfferName = Sextante.getText((String)"Preexistent") + Integer.toString(j);
            }
            for (j = 0; j < this.m_iBestSolution.length; ++j) {
                iPt = this.m_iBestSolution[j];
                if (!(this.m_dDist[i][iPt + this.m_iOffer] < dMin)) continue;
                dMin = this.m_dDist[i][iPt + this.m_iOffer];
                pt = (Coordinate)this.m_Candidates.get(iPt);
                sOfferName = Sextante.getText((String)"Candidate") + Integer.toString(iPt);
            }
            stats.addValue(dMin);
            coords[0] = pt;
            coords[1] = new Coordinate(dpt.x, dpt.y);
            LineString line = gf.createLineString(coords);
            values[0] = new Integer(iID++);
            values[1] = Integer.toString(i);
            values[2] = new Double(dpt.x);
            values[3] = new Double(dpt.y);
            values[4] = sOfferName;
            values[5] = new Double(pt.x);
            values[6] = new Double(pt.y);
            double dDist = Math.sqrt(Math.pow(pt.x - dpt.x, 2.0) + Math.pow(pt.y - dpt.y, 2.0));
            values[7] = new Double(dDist);
            spiderWebLayer.addFeature((Geometry)line, values);
        }
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Result"));
        doc.addHeader(Sextante.getText((String)"Statistics_of_global_solution"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Objective_function") + ": " + df.format(Math.abs(this.m_dObjective)));
        doc.addListElement(Sextante.getText((String)"Mean_distance") + ": " + df.format(stats.getMean()));
        doc.addListElement(Sextante.getText((String)"Mean_squared_distance") + ": " + df.format(stats.getRMS()));
        doc.addListElement(Sextante.getText((String)"Min_distance") + ": " + df.format(stats.getMin()));
        doc.addListElement(Sextante.getText((String)"Maximum_distance") + ": " + df.format(stats.getMax()));
        doc.addListElement(Sextante.getText((String)"Variance") + ": " + df.format(stats.getVariance()));
        doc.addListElement(Sextante.getText((String)"Sum_of_distances") + ": " + df.format(stats.getSum()));
        doc.addListElement(Sextante.getText((String)"Coefficient_of_variation") + ": " + df.format(stats.getCoeffOfVar()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(RESULT, Sextante.getText((String)"Statistics"), doc.getHTMLCode());
    }

    private class DemandPoint {
        public double x;
        public double y;
        public double weight;

        DemandPoint(double dX, double dY, double dWeight) {
            this.x = dX;
            this.y = dY;
            this.weight = dWeight;
        }
    }
}

