/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.surfaceSpecificPoints;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;

public class SurfaceSpecificPointsAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String RESULT = "RESULT";
    IRasterLayer m_DEM = null;
    IRasterLayer m_Result;
    double m_dThreshold;
    int m_iNX;
    int m_iNY;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Result"), 3);
        AnalysisExtent extent = this.m_Result.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        switch (iMethod) {
            case 0: {
                this.doMarkHighestNB();
                break;
            }
            case 1: {
                this.doOppositeNB();
                break;
            }
            case 2: {
                this.doFlowDirection();
                break;
            }
            case 3: {
                this.doPeuckerDouglas();
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Mark_Highest_Neighbour"), Sextante.getText((String)"Opposite_neighbours"), Sextante.getText((String)"Flow_direction"), Sextante.getText((String)"Peucker_&_Douglas")};
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setName(Sextante.getText((String)"Landform_classification"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Threshold__Peucker_&_Douglas"), 0.01, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void doMarkHighestNB() throws UnsupportedOutputChannelException {
        int x;
        int y;
        IRasterLayer clo = this.getTempRasterLayer(0, this.m_Result.getWindowGridExtent());
        IRasterLayer chi = this.getTempRasterLayer(0, this.m_Result.getWindowGridExtent());
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                int ylo;
                int xlo;
                double hi;
                double lo = hi = this.m_DEM.getCellValueAsDouble(x, y);
                int xhi = xlo = x;
                int yhi = ylo = y;
                for (int i = 0; i < 4; ++i) {
                    int ix = x + m_iOffsetX[i];
                    int iy = y + m_iOffsetY[i];
                    double z = this.m_DEM.getCellValueAsDouble(ix, iy);
                    if (this.m_DEM.isNoDataValue(z)) continue;
                    if (z > hi) {
                        hi = z;
                        xhi = ix;
                        yhi = iy;
                        continue;
                    }
                    if (!(z < lo)) continue;
                    lo = z;
                    xlo = ix;
                    ylo = iy;
                }
                this.setProgress(y, this.m_iNY);
                clo.addToCellValue(xlo, ylo, 1.0);
                chi.addToCellValue(xhi, yhi, 1.0);
            }
        }
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                if (chi.getCellValueAsByte(x, y) == 0) {
                    if (clo.getCellValueAsByte(x, y) == 0) {
                        this.m_Result.setCellValue(x, y, 2.0);
                        continue;
                    }
                    this.m_Result.setCellValue(x, y, 1.0);
                    continue;
                }
                if (clo.getCellValueAsByte(x, y) == 0) {
                    this.m_Result.setCellValue(x, y, -1.0);
                    continue;
                }
                this.m_Result.setCellValue(x, y, 0.0);
            }
        }
    }

    private void doOppositeNB() throws UnsupportedOutputChannelException {
        int x;
        int y;
        IRasterLayer clo = this.getTempRasterLayer(0, this.m_Result.getWindowGridExtent());
        IRasterLayer chi = this.getTempRasterLayer(0, this.m_Result.getWindowGridExtent());
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                double z = this.m_DEM.getCellValueAsDouble(x, y);
                for (int i = 0; i < 4; ++i) {
                    int jy;
                    int jx;
                    double jz;
                    int ix = x + m_iOffsetX[i];
                    int iy = y + m_iOffsetY[i];
                    double iz = this.m_DEM.getCellValueAsDouble(ix, iy);
                    if (this.m_DEM.isNoDataValue(iz) || this.m_DEM.isNoDataValue(jz = this.m_DEM.getCellValueAsDouble(jx = x + m_iOffsetX[i + 4], jy = y + m_iOffsetX[i + 4]))) continue;
                    if (iz > z && jz > z) {
                        chi.addToCellValue(x, y, 1.0);
                        continue;
                    }
                    if (!(iz < z) || !(jz < z)) continue;
                    clo.addToCellValue(x, y, 1.0);
                }
            }
        }
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                if (chi.getCellValueAsByte(x, y) != 0) {
                    if (clo.getCellValueAsByte(x, y) != 0) {
                        this.m_Result.setCellValue(x, y, 5.0);
                        continue;
                    }
                    this.m_Result.setCellValue(x, y, (double)chi.getCellValueAsByte(x, y));
                    continue;
                }
                if (clo.getCellValueAsByte(x, y) != 0) {
                    this.m_Result.setCellValue(x, y, (double)(-clo.getCellValueAsByte(x, y)));
                    continue;
                }
                this.m_Result.setCellValue(x, y, 0.0);
            }
        }
    }

    private void doFlowDirection() {
        int xLow = 0;
        int yLow = 0;
        double zLow = 0.0;
        this.m_Result.assign(0.0);
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double z = this.m_DEM.getCellValueAsDouble(x, y);
                boolean bLower = false;
                for (int i = 0; i < 8; ++i) {
                    int ix = x + m_iOffsetX[i];
                    int iy = y + m_iOffsetY[i];
                    double iz = this.m_DEM.getCellValueAsDouble(ix, iy);
                    if (this.m_DEM.isNoDataValue(iz) || !(iz < z)) continue;
                    if (!bLower) {
                        bLower = true;
                        zLow = iz;
                        xLow = ix;
                        yLow = iy;
                        continue;
                    }
                    if (!(iz < zLow)) continue;
                    zLow = iz;
                    xLow = ix;
                    yLow = iy;
                }
                if (!bLower) continue;
                this.m_Result.addToCellValue(xLow, yLow, 1.0);
            }
        }
    }

    private void doPeuckerDouglas() {
        double[] alt = new double[8];
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                int i;
                double z = this.m_DEM.getCellValueAsDouble(x, y);
                for (i = 0; i < 8; ++i) {
                    int ix = x + m_iOffsetX[i];
                    int iy = y + m_iOffsetY[i];
                    double iz = this.m_DEM.getCellValueAsDouble(ix, iy);
                    alt[i] = !this.m_DEM.isNoDataValue(iz) ? iz : z;
                }
                double dMinus = 0.0;
                double dPlus = 0.0;
                int nSgn = 0;
                boolean wasPlus = alt[7] - z > 0.0;
                for (i = 0; i < 8; ++i) {
                    double d = alt[i] - z;
                    if (d > 0.0) {
                        dPlus += d;
                        if (wasPlus) continue;
                        ++nSgn;
                        wasPlus = true;
                        continue;
                    }
                    if (!(d < 0.0)) continue;
                    dMinus -= d;
                    if (!wasPlus) continue;
                    ++nSgn;
                    wasPlus = false;
                }
                i = 0;
                if (dPlus == 0.0) {
                    i = 9;
                } else if (dMinus == 0.0) {
                    i = -9;
                } else if (nSgn == 4) {
                    i = 1;
                } else if (nSgn == 2) {
                    nSgn = 0;
                    i = 0;
                    if (alt[7] > z) {
                        do {
                        } while (alt[i++] > z);
                        do {
                            ++nSgn;
                        } while (alt[i++] < z);
                    } else {
                        do {
                        } while (alt[i++] < z);
                        do {
                            ++nSgn;
                        } while (alt[i++] > z);
                    }
                    i = 0;
                    if (nSgn == 4) {
                        if (dMinus - dPlus > this.m_dThreshold) {
                            i = 2;
                        } else if (dPlus - dMinus > this.m_dThreshold) {
                            i = -2;
                        }
                    } else {
                        i = dMinus - dPlus > 0.0 ? 7 : -7;
                    }
                }
                this.m_Result.setCellValue(x, y, (double)i);
            }
        }
    }
}

