/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.quadrat;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.pdf.PDF;
import java.text.DecimalFormat;

public class QuadratAlgorithm
extends GeoAlgorithm {
    private static final String POINTS = "POINTS";
    private static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Quadrant_analysis"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.addOutputText(RESULT, Sextante.getText((String)"Statistics"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iCount;
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        if ((iCount = this.m_Layer.getShapesCount()) == 0) {
            throw new GeoAlgorithmExecutionException("0 points in layer");
        }
        double dArea = this.m_Layer.getFullExtent().getHeight() * this.m_Layer.getFullExtent().getWidth();
        double dXMin = this.m_Layer.getFullExtent().getMinX();
        double dYMin = this.m_Layer.getFullExtent().getMinY();
        double dWidth = Math.sqrt(dArea * 2.0 / (double)iCount);
        int iCols = (int)Math.ceil(this.m_Layer.getFullExtent().getWidth() / dWidth);
        int iRows = (int)Math.ceil(this.m_Layer.getFullExtent().getHeight() / dWidth);
        int[][] iQuadratCount = new int[iRows][iCols];
        this.setProgressText(Sextante.getText((String)"Creating_quadrants"));
        int i = 0;
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            double x = coord.x;
            double y = coord.y;
            int iCol = (int)Math.floor((x - dXMin) / dWidth);
            int iRow = (int)Math.floor((y - dYMin) / dWidth);
            int[] nArray = iQuadratCount[iRow];
            int n = iCol;
            nArray[n] = nArray[n] + 1;
            ++i;
        }
        iter.close();
        int[] iQuadratsVector = new int[iRows * iCols];
        for (i = 0; i < iRows; ++i) {
            for (int j = 0; j < iCols; ++j) {
                iQuadratsVector[j + i * iCols] = iQuadratCount[i][j];
            }
        }
        this.setProgressText(Sextante.getText((String)"Analyzing_quadrants"));
        this.calculateStats(iQuadratsVector);
        return !this.m_Task.isCanceled();
    }

    private void calculateStats(int[] quadrats) {
        int i;
        int iMax = 0;
        double dMean = 0.0;
        double dVar = 0.0;
        for (i = 0; i < quadrats.length; ++i) {
            dMean += (double)quadrats[i];
            dVar += (double)(quadrats[i] * quadrats[i]);
            iMax = Math.max(iMax, quadrats[i]);
        }
        dVar = dVar / (double)quadrats.length - (dMean /= (double)quadrats.length) * dMean;
        double dClustering = dVar / dMean;
        int[] quadratsFreq = new int[iMax + 1];
        for (i = 0; i < quadrats.length; ++i) {
            int n = quadrats[i];
            quadratsFreq[n] = quadratsFreq[n] + 1;
        }
        double dObsProb = 0.0;
        double dPoissonProb = 0.0;
        double dMaxDiff = 0.0;
        double dDiff = 0.0;
        for (i = 0; i < quadratsFreq.length; ++i) {
            dDiff = Math.abs((dObsProb += (double)quadratsFreq[i] / (double)quadrats.length) - (dPoissonProb += PDF.poisson((int)i, (double)dMean)));
            dMaxDiff = Math.max(dMaxDiff, dDiff);
        }
        double dKS = 1.36 / Math.sqrt(quadrats.length);
        DecimalFormat df = new DecimalFormat("##.######");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Quadrant_analysis"));
        doc.addHeader(Sextante.getText((String)"Quadrant_analysis"), 1);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Mean") + ": " + df.format(dMean));
        doc.addListElement(Sextante.getText((String)"Variance") + ": " + df.format(dVar));
        doc.addListElement(Sextante.getText((String)"Coefficient_of_variation_[~0") + ": " + df.format(dClustering));
        doc.addListElement(Sextante.getText((String)"D_value__Kolmogorov-Smirnov") + ": " + df.format(dMaxDiff));
        doc.addListElement(Sextante.getText((String)"Critical_value__at_5%") + ": " + df.format(dKS));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(RESULT, Sextante.getText((String)"Statistics") + "[" + this.m_Layer.getName() + "]", doc.getHTMLCode());
    }
}

