/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rTree;

import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTree;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.closestpts.Point3D;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.IteratorException;
import java.util.Properties;

public class SextanteRTree {
    private final RTree m_Tree;
    private final int m_iPoints;
    private final double[] m_dX;
    private final double[] m_dY;
    private final double[] m_dZ;

    public SextanteRTree(IVectorLayer layer, int iField, ITaskMonitor task) {
        task.setProgressText(Sextante.getText((String)"Creating_index"));
        this.m_Tree = new RTree();
        this.m_Tree.init(new Properties());
        this.m_iPoints = layer.getShapesCount();
        this.m_dX = new double[this.m_iPoints];
        this.m_dY = new double[this.m_iPoints];
        this.m_dZ = new double[this.m_iPoints];
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && !task.isCanceled()) {
            try {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                Coordinate coord = geom.getCoordinate();
                float x = (float)coord.x;
                float y = (float)coord.y;
                Rectangle rectangle = new Rectangle(x, y, x, y);
                this.m_Tree.add(rectangle, i);
                this.m_dX[i] = x;
                this.m_dY[i] = y;
                try {
                    this.m_dZ[i] = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                }
                catch (Exception e) {
                    this.m_dZ[i] = 0.0;
                }
                if (i % 50 == 0) {
                    task.setProgress(i, this.m_iPoints);
                }
                ++i;
            }
            catch (IteratorException iteratorException) {}
        }
    }

    public Point3D getClosestPoint(double x, double y) {
        Point pt = new Point((float)x, (float)y);
        int iIdx = this.m_Tree.nearest(pt);
        return new Point3D(this.m_dX[iIdx], this.m_dY[iIdx], this.m_dZ[iIdx]);
    }
}

