/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rasterize.rasterizeVectorLayerForMask;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.Arrays;

public class RasterizeVectorLayerForMaskAlgorithm
extends GeoAlgorithm {
    private double NO_DATA;
    public static final String LAYER = "LAYER";
    public static final String FIELD = "FIELD";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IVectorLayer m_Layer;
    private IRasterLayer m_Result;
    private AnalysisExtent m_Extent;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Rasterize_vector_layer_for_mask"));
        this.setGroup(Sextante.getText((String)"Rasterization_and_interpolation"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Vector_layer"), -1, true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.NO_DATA = 0.0;
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Layer.getName() + Sextante.getText((String)"[rasterizedo]"), 5);
        this.m_Result.setNoDataValue(this.NO_DATA);
        this.m_Result.assignNoData();
        this.m_Extent = this.m_Result.getWindowGridExtent();
        this.m_iNX = this.m_Extent.getNX();
        this.m_iNY = this.m_Extent.getNY();
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMin()), new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMax()), new Coordinate(this.m_Extent.getXMax(), this.m_Extent.getYMax()), new Coordinate(this.m_Extent.getXMax(), this.m_Extent.getYMin()), new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMin())};
        GeometryFactory gf = new GeometryFactory();
        LinearRing ring = gf.createLinearRing(coords);
        Polygon extent = gf.createPolygon(ring, null);
        int i = 0;
        int iType = this.m_Layer.getShapeType();
        int iShapeCount = this.m_Layer.getShapesCount();
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            IRecord record = feature.getRecord();
            Geometry geometry = feature.getGeometry();
            if (geometry.intersects((Geometry)extent)) {
                switch (iType) {
                    case 0: {
                        this.doPoint(geometry, 1.0);
                        break;
                    }
                    case 1: {
                        this.doLine(geometry, 1.0);
                        break;
                    }
                    case 2: {
                        this.doPolygon(geometry, 1.0);
                    }
                }
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void doPolygon(Geometry geom, double dValue) {
        GeometryFactory gf = new GeometryFactory();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)geom.getGeometryN(i);
            LinearRing lr = gf.createLinearRing(poly.getExteriorRing().getCoordinates());
            Polygon part = gf.createPolygon(lr, null);
            this.doPolygonPart(part, dValue, false);
            for (int j = 0; j < poly.getNumInteriorRing(); ++j) {
                lr = gf.createLinearRing(poly.getInteriorRingN(j).getCoordinates());
                part = gf.createPolygon(lr, null);
                this.doPolygonPart(part, dValue, true);
            }
        }
    }

    private void doPolygonPart(Polygon geom, double dValue, boolean bIsHole) {
        int xStop;
        Coordinate p = new Coordinate();
        boolean[] bCrossing = new boolean[this.m_iNX];
        Envelope extent = geom.getEnvelopeInternal();
        int xStart = (int)((extent.getMinX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) - 1;
        if (xStart < 0) {
            xStart = 0;
        }
        if ((xStop = (int)((extent.getMaxX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) + 1) >= this.m_iNX) {
            xStop = this.m_iNX - 1;
        }
        Coordinate[] points = geom.getCoordinates();
        int y = 0;
        double yPos = this.m_Extent.getYMax();
        while (y < this.m_iNY) {
            if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                Arrays.fill(bCrossing, false);
                Coordinate pLeft = new Coordinate(this.m_Extent.getXMin() - 1.0, yPos);
                Coordinate pRight = new Coordinate(this.m_Extent.getXMax() + 1.0, yPos);
                Coordinate pb = points[points.length - 1];
                for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                    Coordinate pa = pb;
                    pb = points[iPoint];
                    if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                    this.getCrossing(p, pa, pb, pLeft, pRight);
                    int ix = (int)((p.x - this.m_Extent.getXMin()) / this.m_Extent.getCellSize() + 1.0);
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= this.m_iNX) {
                        ix = this.m_iNX - 1;
                    }
                    bCrossing[ix] = !bCrossing[ix];
                }
                boolean bFill = false;
                for (int x = xStart; x <= xStop; ++x) {
                    if (bCrossing[x]) {
                        boolean bl = bFill = !bFill;
                    }
                    if (!bFill) continue;
                    double dPrevValue = this.m_Result.getCellValueAsDouble(x, y);
                    if (bIsHole) {
                        if (dPrevValue != dValue) continue;
                        this.m_Result.setNoData(x, y);
                        continue;
                    }
                    if (dPrevValue != this.NO_DATA) continue;
                    this.m_Result.setCellValue(x, y, dValue);
                }
            }
            ++y;
            yPos -= this.m_Extent.getCellSize();
        }
    }

    private void doLine(Geometry geom, double dValue) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doLineString(part, dValue);
        }
    }

    private void doLineString(Geometry geom, double dValue) {
        Coordinate[] coords = geom.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            this.writeSegment(x, y, x2, y2, dValue);
        }
    }

    private void writeSegment(double x, double y, double x2, double y2, double dValue) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= this.m_Result.getWindowCellSize();
                dy /= dx;
                dx = this.m_Result.getWindowCellSize();
            } else {
                n = dy /= this.m_Result.getWindowCellSize();
                dx /= dy;
                dy = this.m_Result.getWindowCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                if (this.m_Extent.contains(x, y)) {
                    GridCell cell = this.m_Extent.getGridCoordsFromWorldCoords(x, y);
                    this.m_Result.setCellValue(cell.getX(), cell.getY(), dValue);
                }
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private void doPoint(Geometry geometry, double dValue) {
        Coordinate coord = geometry.getCoordinate();
        GridCell cell = this.m_Extent.getGridCoordsFromWorldCoords(coord.x, coord.y);
        this.m_Result.setCellValue(cell.getX(), cell.getY(), dValue);
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }
}

