/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.multipleRegression;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.math.regression.MultipleRegression;
import es.unex.sextante.rasterWrappers.GridCell;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class MultipleRegressionAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String FIELD = "FIELD";
    public static final String POINTS = "POINTS";
    public static final String RESULT = "RESULT";
    public static final String RESIDUALS = "RESIDUALS";
    public static final String REGRESSION_INFO = "REGRESSION_INFO";
    private int m_iField;
    private IVectorLayer m_Residuals;
    private IRasterLayer[] m_Windows;
    private IRasterLayer m_Result;
    private MultipleRegression m_Regression;
    private ArrayList m_RasterLayers;
    private IVectorLayer m_Points;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setName(Sextante.getText((String)"Multiple_regression"));
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), POINTS);
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Predictors"), 1, false);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
            this.addOutputVectorLayer(RESIDUALS, Sextante.getText((String)"Residuals"), 0);
            this.addOutputText(REGRESSION_INFO, Sextante.getText((String)"Regression_values"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sFieldNames = new String[]{Sextante.getText((String)"Real_value"), Sextante.getText((String)"Estimated_value"), Sextante.getText((String)"Diference")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class};
        this.m_RasterLayers = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (this.m_RasterLayers.size() == 0 || this.m_Points.getShapesCount() < 3) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Invalid_input_data"));
        }
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Multiple_regression"), 4);
        this.m_Windows = new IRasterLayer[this.m_RasterLayers.size()];
        for (int i = 0; i < this.m_RasterLayers.size(); ++i) {
            this.m_Windows[i] = (IRasterLayer)this.m_RasterLayers.get(i);
            this.m_Windows[i].setWindowExtent(this.m_Result.getWindowGridExtent());
            this.m_Windows[i].setInterpolationMethod(4);
        }
        this.m_Residuals = this.getNewVectorLayer(RESIDUALS, Sextante.getText((String)"Residuals"), 0, types, sFieldNames);
        this.calculateRegression();
        if (!this.m_Task.isCanceled()) {
            this.calculateResultingGrid();
            this.calculateResiduals();
            this.createAdditionalInfo();
        }
        return !this.m_Task.isCanceled();
    }

    private void calculateResiduals() throws IteratorException {
        Object[] value = new Object[3];
        AnalysisExtent extent = this.m_Result.getWindowGridExtent();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate pt = geom.getCoordinate();
            double dValue = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
            GridCell cell = extent.getGridCoordsFromWorldCoords(pt.x, pt.y);
            double dGridValue = this.m_Result.getCellValueAsDouble(cell.getX(), cell.getY());
            if (this.m_Result.isNoDataValue(dGridValue)) continue;
            value[1] = new Double(dValue);
            value[0] = new Double(dGridValue);
            value[2] = new Double(dGridValue - dValue);
            this.m_Residuals.addFeature(geom, value);
        }
        iter.close();
    }

    private void calculateResultingGrid() {
        int iNX = this.m_Windows[0].getNX();
        int iNY = this.m_Windows[0].getNY();
        this.setProgressText(Sextante.getText((String)"Calculating_regression"));
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                boolean bNoDataValue = false;
                double z = this.m_Regression.getConstant();
                for (int i = 0; i < this.m_Windows.length; ++i) {
                    double dValue = this.m_Windows[i].getCellValueAsDouble(x, y);
                    if (this.m_Windows[i].isNoDataValue(dValue)) {
                        this.m_Result.setNoData(x, y);
                        bNoDataValue = true;
                        break;
                    }
                    z += dValue * this.m_Regression.getCoeff(i);
                }
                if (bNoDataValue) continue;
                this.m_Result.setCellValue(x, y, z);
            }
        }
    }

    private void calculateRegression() throws GeoAlgorithmExecutionException {
        double[] dValueGrid = new double[this.m_Windows.length];
        this.m_Regression = new MultipleRegression(this.m_Windows.length);
        int i = 0;
        int iCount = this.m_Points.getShapesCount();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate pt = geom.getCoordinate();
            boolean bNoDataValue = false;
            for (int j = 0; j < this.m_Windows.length; ++j) {
                dValueGrid[j] = this.m_Windows[j].getValueAt(pt.x, pt.y);
                if (!this.m_Windows[j].isNoDataValue(dValueGrid[j])) continue;
                bNoDataValue = true;
                break;
            }
            if (bNoDataValue) continue;
            try {
                double dValuePt = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
                this.m_Regression.addValue(dValueGrid, dValuePt);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return;
        }
        boolean bResult = this.m_Regression.calculate();
        if (!bResult) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Could_not_calculate_regression"));
        }
    }

    private void createAdditionalInfo() {
        IRasterLayer layer;
        int j;
        int i;
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Multiple_regression"));
        doc.addHeader(Sextante.getText((String)"Multiple_regression"), 2);
        doc.startUnorderedList();
        StringBuffer sb = new StringBuffer(" Y = " + Double.toString(this.m_Regression.getConstant()));
        for (i = 0; i < this.m_RasterLayers.size(); ++i) {
            j = this.m_Regression.getOrdered(i);
            if (j < 0 || j >= this.m_RasterLayers.size()) continue;
            layer = (IRasterLayer)this.m_RasterLayers.get(j);
            sb.append(" + " + Double.toString(this.m_Regression.getCoeff(j)) + " * [" + layer.getName() + "]");
        }
        doc.addListElement(sb.toString());
        doc.closeUnorderedList();
        doc.startUnorderedList();
        doc.addHeader(Sextante.getText((String)"Correlation"), 2);
        for (i = 0; i < this.m_RasterLayers.size(); ++i) {
            j = this.m_Regression.getOrdered(i);
            if (j < 0 || j >= this.m_RasterLayers.size()) continue;
            layer = (IRasterLayer)this.m_RasterLayers.get(j);
            doc.addListElement(Integer.toString(i + 1) + ": R2 = " + df.format(100.0 * this.m_Regression.getR2(j)) + "[" + df.format(100.0 * this.m_Regression.getR2Change(j)) + "] -> " + layer.getName());
        }
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(REGRESSION_INFO, Sextante.getText((String)"Regression_values"), doc.getHTMLCode());
    }
}

