/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.pdfExponential;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.pdf.PDF;

public class PDFExponentialAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String CDF = "CDF";
    public static final String MEAN = "MEAN";
    public static final String STDDEV = "STDDEV";
    public static final String PROBABILITY = "PROBABILITY";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Exponential_probability_distribution"));
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Raster_layer"), true);
            this.m_Parameters.addNumericalValue(MEAN, Sextante.getText((String)"Mean"), 0.0, 2);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Standard_deviation"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addBoolean(CDF, Sextante.getText((String)"Accumulated_probability"), false);
            this.addOutputRasterLayer(PROBABILITY, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        boolean bCDF = this.m_Parameters.getParameterValueAsBoolean(CDF);
        double dMean = this.m_Parameters.getParameterValueAsDouble(MEAN);
        double dStdDev = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        window.setFullExtent();
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)window);
        IRasterLayer result = this.getNewRasterLayer(PROBABILITY, Sextante.getText((String)"Probability__exponential"), 5, gridExtent);
        int iNX = window.getNX();
        int iNY = window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = window.getCellValueAsDouble(x, y);
                if (!window.isNoDataValue(dValue)) {
                    if (bCDF) {
                        result.setCellValue(x, y, PDF.exponentialCDF((double)dMean, (double)dStdDev, (double)dValue));
                        continue;
                    }
                    result.setCellValue(x, y, PDF.exponential((double)dMean, (double)dStdDev, (double)dValue));
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

