/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.vectorFieldCalculator;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.LayerCannotBeOverwrittenException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.tables.vectorFieldCalculator.CalculatorKeysPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.nfunk.jep.JEP;

public class VectorFieldCalculatorParametersPanel
extends GeoAlgorithmParametersPanel {
    private JTextArea jTextExpression;
    private JScrollPane jScrollPane;
    private JTree jTree;
    private JScrollPane jScrollPane1;
    private CalculatorKeysPanel m_KeysPanel;
    private JPanel jPanel;
    private HashMap m_Constants;
    private GeoAlgorithm m_Algorithm;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;
    private JComboBox comboBox;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        this.setPreferredSize(new Dimension(570, 350));
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{10.0, -1.0, -1.0, -1.0, -1.0, 10.0}, {10.0, -1.0, -1.0, -1.0, 50.0, 5.0, 20.0, 10.0}});
        thisLayout.setHGap(10);
        thisLayout.setVGap(10);
        this.setLayout((LayoutManager)thisLayout);
        this.setSize(new Dimension(350, 350));
        this.jScrollPane = new JScrollPane();
        this.add(this.jScrollPane, "1, 4, 4, 4");
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jTextExpression = new JTextArea();
        this.jScrollPane.setViewportView(this.jTextExpression);
        this.jTextExpression.setPreferredSize(new Dimension(0, 0));
        this.jTextExpression.setBorder(BorderFactory.createBevelBorder(1));
        this.m_KeysPanel = new CalculatorKeysPanel(this.jTextExpression);
        this.add(this.m_KeysPanel, "3, 1, 4, 3");
        this.jPanel = new JPanel();
        TableLayout panelLayout = new TableLayout((double[][])new double[][]{{-1.0}, {20.0, -1.0}});
        this.jPanel.setLayout((LayoutManager)panelLayout);
        this.add(this.jPanel, "1, 1, 2, 3");
        this.jScrollPane1 = new JScrollPane();
        this.jPanel.add((Component)this.jScrollPane1, "0,1");
        this.jTree = new JTree();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int iRow = VectorFieldCalculatorParametersPanel.this.jTree.getRowForLocation(e.getX(), e.getY());
                TreePath path = VectorFieldCalculatorParametersPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (iRow != -1 && e.getClickCount() == 2) {
                    VectorFieldCalculatorParametersPanel.this.insertTextFromTree(path);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        this.jScrollPane1.setViewportView(this.jTree);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTree.setBorder(BorderFactory.createBevelBorder(1));
        this.comboBox = new JComboBox();
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        DefaultComboBoxModel<IVectorLayer> defaultModel = new DefaultComboBoxModel<IVectorLayer>(layers);
        this.comboBox.setModel(defaultModel);
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VectorFieldCalculatorParametersPanel.this.populateTree();
            }
        });
        this.jPanel.add((Component)this.comboBox, "0,0");
        this.populateTree();
        try {
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
            this.add((Component)this.outputChannelSelectionPanel, "3,6,4,6");
            this.add(new JLabel(Sextante.getText((String)"Result")), "1,6,2,6");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void populateTree() {
        DefaultMutableTreeNode child;
        int i;
        this.jTree.setModel(null);
        DefaultMutableTreeNode main = new DefaultMutableTreeNode(Sextante.getText((String)"ELEMENTS"));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(Sextante.getText((String)"Fields"));
        IVectorLayer layer = (IVectorLayer)this.comboBox.getSelectedItem();
        try {
            String[] fieldNames = layer.getFieldNames();
            for (i = 0; i < fieldNames.length; ++i) {
                child = new DefaultMutableTreeNode(fieldNames[i]);
                node.add(child);
            }
        }
        catch (Exception fieldNames) {
            // empty catch block
        }
        main.add(node);
        String[] sFunctions = new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ln", "log", "exp", "abs", "rand", "mod", "sqrt", "if"};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Functions"));
        for (i = 0; i < sFunctions.length; ++i) {
            child = new DefaultMutableTreeNode(" " + sFunctions[i] + "() ");
            node.add(child);
        }
        main.add(node);
        String[] sOperators = new String[]{"+", "-", "*", "/", "%", "!", "^", "&&", "||", "<", ">", "<=", ">=", "==", "!="};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Operators"));
        for (i = 0; i < sOperators.length; ++i) {
            child = new DefaultMutableTreeNode(" " + sOperators[i] + " ");
            node.add(child);
        }
        main.add(node);
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Constants"));
        this.m_Constants = new HashMap();
        this.m_Constants.put("e", " " + Double.toString(Math.E) + " ");
        this.m_Constants.put("Pi", " " + Double.toString(Math.PI) + " ");
        Set set = this.m_Constants.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            child = new DefaultMutableTreeNode(iter.next());
            node.add(child);
        }
        main.add(node);
        this.jTree.setModel(new DefaultTreeModel(main));
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jTree.getCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
    }

    private void insertTextFromTree(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent != null && !parent.toString().equals("[" + Sextante.getText((String)"ELEMENTS") + "]")) {
            String sParentName = parent.toString();
            String s = path.getLastPathComponent().toString();
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Constants]"))) {
                s = this.m_Constants.containsKey(s) ? (String)this.m_Constants.get(s) : "";
            }
            this.jTextExpression.insert(s, this.jTextExpression.getCaretPosition());
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Functions]"))) {
                this.jTextExpression.setCaretPosition(this.jTextExpression.getCaretPosition() - 2);
            }
        }
    }

    public void assignParameters() throws WrongInputException, LayerCannotBeOverwrittenException {
        OverwriteOutputChannel ooc;
        IOutputChannel channel;
        Output out;
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        String sFormula = this.jTextExpression.getText().toLowerCase();
        sFormula = sFormula.toLowerCase().replaceAll(" ", "");
        sFormula = this.replaceDots(sFormula);
        IVectorLayer layer = (IVectorLayer)this.comboBox.getSelectedItem();
        try {
            String[] fieldNames = layer.getFieldNames();
            for (int i = 0; i < fieldNames.length; ++i) {
                String sFieldName = fieldNames[i].toLowerCase();
                sFieldName = sFieldName.replaceAll(" ", "");
                sFieldName = sFieldName.replaceAll("\\.", "");
                if (sFormula.lastIndexOf(sFieldName = this.replaceDots(sFieldName)) == -1) continue;
                jep.addVariable(sFieldName, 0.0);
            }
        }
        catch (Exception fieldNames) {
            // empty catch block
        }
        jep.parseExpression(sFormula);
        if (jep.hasError()) {
            throw new WrongInputException();
        }
        try {
            this.m_Algorithm.getParameters().getParameter("LAYER").setParameterValue((Object)layer);
            this.m_Algorithm.getParameters().getParameter("FORMULA").setParameterValue((Object)sFormula);
        }
        catch (Exception e) {
            throw new WrongInputException();
        }
        OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
        try {
            out = ooSet.getOutput("RESULT");
            channel = this.outputChannelSelectionPanel.getOutputChannel();
        }
        catch (Exception e) {
            throw new WrongInputException();
        }
        if (channel instanceof OverwriteOutputChannel && !(ooc = (OverwriteOutputChannel)channel).getLayer().canBeEdited()) {
            throw new LayerCannotBeOverwrittenException();
        }
        out.setOutputChannel(channel);
    }

    private String replaceDots(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length() - 1; ++i) {
            char c = sb.charAt(i);
            char c2 = sb.charAt(i + 1);
            if (c != '.' || Character.isDigit(c2)) continue;
            sb = sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public void setOutputValue(String outputName, String sValue) {
        this.outputChannelSelectionPanel.setText(sValue);
    }

    public void setParameterValue(String parameterName, String value) {
        if (parameterName.equals("FORMULA")) {
            this.jTextExpression.setText(value);
        }
    }
}

