/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.smoothTinBezier;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import es.unex.sextante.tin.smoothTinBezier.Bezier;
import es.unex.sextante.tin.smoothTinBezier.TriangleDT;
import java.util.Iterator;
import java.util.LinkedList;

class Bezier2 {
    Coordinate normalN1 = null;
    Coordinate normalN2 = null;
    Coordinate normalN3 = null;
    Coordinate b300;
    Coordinate b030;
    Coordinate b003;
    Coordinate b012 = null;
    Coordinate b021 = null;
    Coordinate b102 = null;
    Coordinate b120 = null;
    Coordinate b210 = null;
    Coordinate b201 = null;
    Coordinate A111 = null;
    Coordinate B111 = null;
    Coordinate C111 = null;
    Coordinate G = null;
    Coordinate A201;
    Coordinate A102;
    Coordinate A012;
    Coordinate A021;
    Coordinate B201;
    Coordinate B102;
    Coordinate n200 = null;
    Coordinate n020 = null;
    Coordinate n002 = null;
    Coordinate n110 = null;
    Coordinate n011 = null;
    Coordinate n101 = null;

    Bezier2(TriangleDT T, LinkedList listA, LinkedList listB, LinkedList listC, int typeOfBreakLine) {
        this.b300 = T.A;
        this.b030 = T.B;
        this.b003 = T.C;
        this.setNormalVector(listA, listB, listC);
        this.setControlPoints(typeOfBreakLine);
    }

    Bezier2(Coordinate[] coords) {
        this.b300 = coords[0];
        this.b030 = coords[1];
        this.b003 = coords[2];
    }

    Bezier2(Coordinate[] coords, LinkedList listA, LinkedList listB, LinkedList listC, int typeOfBreakLine) {
        this.b300 = coords[0];
        this.b030 = coords[1];
        this.b003 = coords[2];
        this.setNormalVector(listA, listB, listC);
        this.setControlPoints(typeOfBreakLine);
    }

    protected void setNormalVector(LinkedList listA, LinkedList listB, LinkedList listC) {
        this.normalN1 = Bezier2.countVector(listA, this.b300);
        this.normalN2 = Bezier2.countVector(listB, this.b030);
        this.normalN3 = Bezier2.countVector(listC, this.b003);
    }

    protected static Coordinate setVector(Coordinate A, Coordinate B) {
        return new Coordinate(B.x - A.x, B.y - A.y, B.z - A.z);
    }

    protected static Coordinate setNormalVector(Coordinate A, Coordinate B) {
        Coordinate normal = new Coordinate(A.y * B.z - A.z * B.y, A.z * B.x - A.x * B.z, A.x * B.y - A.y * B.x);
        double sum = Math.sqrt(Math.pow(normal.x, 2.0) + Math.pow(normal.y, 2.0) + Math.pow(normal.z, 2.0));
        if (normal.z > 0.0) {
            return new Coordinate(normal.x / sum, normal.y / sum, normal.z / sum);
        }
        return new Coordinate(-1.0 * (normal.x / sum), -1.0 * (normal.y / sum), -1.0 * (normal.z / sum));
    }

    private static Coordinate countVector(LinkedList list, Coordinate P) {
        Iterator iter = list.iterator();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        while (iter.hasNext()) {
            Coordinate X = (Coordinate)iter.next();
            sumX += X.x;
            sumY += X.y;
            sumZ += X.z;
        }
        double sum = Math.sqrt(Math.pow(sumX, 2.0) + Math.pow(sumY, 2.0) + Math.pow(sumZ, 2.0));
        return new Coordinate(sumX / sum, sumY / sum, sumZ / sum);
    }

    protected static double countScalarProduct(Coordinate v1, Coordinate v2) {
        double scalar = v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
        return scalar;
    }

    protected static Coordinate countCrossProduct(Coordinate A, Coordinate B) {
        Coordinate normal = new Coordinate(A.y * B.z - A.z * B.y, A.z * B.x - A.x * B.z, A.x * B.y - A.y * B.x);
        double sum = Math.sqrt(Math.pow(normal.x, 2.0) + Math.pow(normal.y, 2.0) + Math.pow(normal.z, 2.0));
        if (normal.z > 0.0) {
            return new Coordinate(normal.x / sum, normal.y / sum, normal.z / sum);
        }
        return new Coordinate(-1.0 * (normal.x / sum), -1.0 * (normal.y / sum), -1.0 * (normal.z / sum));
    }

    protected static Coordinate countDifferenceProduct(Coordinate v1, Coordinate v2) {
        return new Coordinate(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z);
    }

    protected static Coordinate countSumProduct(Coordinate v1, Coordinate v2) {
        return new Coordinate(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
    }

    protected static Coordinate normalizeVect(Coordinate v) {
        double sum = Math.sqrt(Math.pow(v.x, 2.0) + Math.pow(v.y, 2.0) + Math.pow(v.z, 2.0));
        return new Coordinate(v.x / sum, v.y / sum, v.z / sum);
    }

    private double helpCount(Coordinate Pi, Coordinate Pj, Coordinate Ni, Coordinate Nj) {
        return 2.0 * (Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(Pj, Pi), Bezier2.countSumProduct(Ni, Nj)) / Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(Pj, Pi), Bezier2.countDifferenceProduct(Pj, Pi)));
    }

    protected void setQuadraticNormals() {
        this.n200 = this.normalN1;
        this.n020 = this.normalN2;
        this.n002 = this.normalN3;
        double help = this.helpCount(this.b300, this.b030, this.normalN1, this.normalN2);
        Coordinate dif = Bezier2.countDifferenceProduct(this.b030, this.b300);
        dif.x *= help;
        dif.y *= help;
        dif.z *= help;
        this.n110 = Bezier2.normalizeVect(Bezier2.countDifferenceProduct(Bezier2.countSumProduct(this.normalN1, this.normalN2), dif));
        help = this.helpCount(this.b030, this.b003, this.normalN2, this.normalN3);
        dif = Bezier2.countDifferenceProduct(this.b003, this.b030);
        dif.x *= help;
        dif.y *= help;
        dif.z *= help;
        this.n011 = Bezier2.normalizeVect(Bezier2.countDifferenceProduct(Bezier2.countSumProduct(this.normalN2, this.normalN3), dif));
        help = this.helpCount(this.b003, this.b300, this.normalN3, this.normalN1);
        dif = Bezier2.countDifferenceProduct(this.b300, this.b003);
        dif.x *= help;
        dif.y *= help;
        dif.z *= help;
        this.n101 = Bezier2.normalizeVect(Bezier2.countDifferenceProduct(Bezier2.countSumProduct(this.normalN3, this.normalN1), dif));
    }

    protected Coordinate getNormal(double u, double v) {
        double w = 1.0 - (u + v);
        double x = this.n200.x * Math.pow(w, 2.0) + this.n020.x * Math.pow(u, 2.0) + this.n002.x * Math.pow(v, 2.0) + this.n110.x * w * u + this.n011.x * u * v + this.n101.x * w * v;
        double y = this.n200.y * Math.pow(w, 2.0) + this.n020.y * Math.pow(u, 2.0) + this.n002.y * Math.pow(v, 2.0) + this.n110.y * w * u + this.n011.y * u * v + this.n101.y * w * v;
        double z = this.n200.z * Math.pow(w, 2.0) + this.n020.z * Math.pow(u, 2.0) + this.n002.z * Math.pow(v, 2.0) + this.n110.z * w * u + this.n011.z * u * v + this.n101.z * w * v;
        return new Coordinate(x, y, z);
    }

    protected Coordinate countProjectOnToPlane(Coordinate pointOfPlane, Coordinate normalOfPlane, Coordinate pointOfLine, Coordinate normalOfLine) {
        double d = -normalOfPlane.x * pointOfPlane.x - normalOfPlane.y * pointOfPlane.y - normalOfPlane.z * pointOfPlane.z;
        double param = (-pointOfLine.x * normalOfPlane.x - pointOfLine.y * normalOfPlane.y - pointOfLine.z * normalOfPlane.z - d) / (normalOfLine.x * normalOfPlane.x + normalOfLine.y * normalOfPlane.y + normalOfLine.z * normalOfPlane.z);
        return new Coordinate(pointOfLine.x + param * normalOfLine.x, pointOfLine.y + param * normalOfLine.y, pointOfLine.z + param * normalOfLine.z);
    }

    protected void setControlPoints(int typeOfBreakLine) {
        this.setQuadraticNormals();
        switch (typeOfBreakLine) {
            case -1: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                break;
            }
            case 0: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x) / 3.0, (2.0 * this.b300.y + this.b030.y) / 3.0, (2.0 * this.b300.z + this.b030.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x) / 3.0, (2.0 * this.b030.y + this.b300.y) / 3.0, (2.0 * this.b030.z + this.b300.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                break;
            }
            case 1: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x) / 3.0, (2.0 * this.b030.y + this.b003.y) / 3.0, (2.0 * this.b030.z + this.b003.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x) / 3.0, (2.0 * this.b003.y + this.b030.y) / 3.0, (2.0 * this.b003.z + this.b030.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                break;
            }
            case 2: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x) / 3.0, (2.0 * this.b300.y + this.b003.y) / 3.0, (2.0 * this.b300.z + this.b003.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x) / 3.0, (2.0 * this.b003.y + this.b300.y) / 3.0, (2.0 * this.b003.z + this.b300.z) / 3.0);
                break;
            }
            case 3: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x) / 3.0, (2.0 * this.b300.y + this.b030.y) / 3.0, (2.0 * this.b300.z + this.b030.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x) / 3.0, (2.0 * this.b030.y + this.b300.y) / 3.0, (2.0 * this.b030.z + this.b300.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x) / 3.0, (2.0 * this.b300.y + this.b003.y) / 3.0, (2.0 * this.b300.z + this.b003.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x) / 3.0, (2.0 * this.b003.y + this.b300.y) / 3.0, (2.0 * this.b003.z + this.b300.z) / 3.0);
                break;
            }
            case 5: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b030.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b030.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b030, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.x) / 3.0, (2.0 * this.b030.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.y) / 3.0, (2.0 * this.b030.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b030), this.normalN2) * this.normalN2.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x) / 3.0, (2.0 * this.b030.y + this.b003.y) / 3.0, (2.0 * this.b030.z + this.b003.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x) / 3.0, (2.0 * this.b003.y + this.b030.y) / 3.0, (2.0 * this.b003.z + this.b030.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x) / 3.0, (2.0 * this.b300.y + this.b003.y) / 3.0, (2.0 * this.b300.z + this.b003.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x) / 3.0, (2.0 * this.b003.y + this.b300.y) / 3.0, (2.0 * this.b003.z + this.b300.z) / 3.0);
                break;
            }
            case 4: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x) / 3.0, (2.0 * this.b300.y + this.b030.y) / 3.0, (2.0 * this.b300.z + this.b030.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x) / 3.0, (2.0 * this.b030.y + this.b300.y) / 3.0, (2.0 * this.b030.z + this.b300.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x) / 3.0, (2.0 * this.b030.y + this.b003.y) / 3.0, (2.0 * this.b030.z + this.b003.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x) / 3.0, (2.0 * this.b003.y + this.b030.y) / 3.0, (2.0 * this.b003.z + this.b030.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.x) / 3.0, (2.0 * this.b300.y + this.b003.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.y) / 3.0, (2.0 * this.b300.z + this.b003.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b003, this.b300), this.normalN1) * this.normalN1.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.x) / 3.0, (2.0 * this.b003.y + this.b300.y - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.y) / 3.0, (2.0 * this.b003.z + this.b300.z - Bezier2.countScalarProduct(Bezier2.countDifferenceProduct(this.b300, this.b003), this.normalN3) * this.normalN3.z) / 3.0);
                break;
            }
            case 6: {
                this.b210 = new Coordinate((2.0 * this.b300.x + this.b030.x) / 3.0, (2.0 * this.b300.y + this.b030.y) / 3.0, (2.0 * this.b300.z + this.b030.z) / 3.0);
                this.b120 = new Coordinate((2.0 * this.b030.x + this.b300.x) / 3.0, (2.0 * this.b030.y + this.b300.y) / 3.0, (2.0 * this.b030.z + this.b300.z) / 3.0);
                this.b021 = new Coordinate((2.0 * this.b030.x + this.b003.x) / 3.0, (2.0 * this.b030.y + this.b003.y) / 3.0, (2.0 * this.b030.z + this.b003.z) / 3.0);
                this.b012 = new Coordinate((2.0 * this.b003.x + this.b030.x) / 3.0, (2.0 * this.b003.y + this.b030.y) / 3.0, (2.0 * this.b003.z + this.b030.z) / 3.0);
                this.b201 = new Coordinate((2.0 * this.b300.x + this.b003.x) / 3.0, (2.0 * this.b300.y + this.b003.y) / 3.0, (2.0 * this.b300.z + this.b003.z) / 3.0);
                this.b102 = new Coordinate((2.0 * this.b003.x + this.b300.x) / 3.0, (2.0 * this.b003.y + this.b300.y) / 3.0, (2.0 * this.b003.z + this.b300.z) / 3.0);
            }
        }
        this.G = new Coordinate((this.b300.x + this.b030.x + this.b003.x) / 3.0, (this.b300.y + this.b030.y + this.b003.y) / 3.0, (this.b300.z + this.b030.z + this.b003.z) / 3.0);
        Coordinate normalOfT = new Coordinate(0.0, 0.0, 1.0);
        this.A111 = new Coordinate((this.b300.x + this.b030.x + this.G.x) / 3.0, (this.b300.y + this.b030.y + this.G.y) / 3.0, (this.b300.z + this.b030.z + this.G.z) / 3.0);
        Coordinate e1 = Bezier2.normalizeVect(this.getNormal(0.5, 0.0));
        Coordinate e2 = Bezier2.normalizeVect(Bezier2.countDifferenceProduct(this.b120, this.b210));
        Coordinate normalOfPlane = Bezier2.setNormalVector(Bezier2.countCrossProduct(e1, e2), e2);
        this.A111 = new Coordinate(this.countProjectOnToPlane(this.b120, normalOfPlane, this.A111, normalOfT));
        this.B111 = new Coordinate((this.b003.x + this.b030.x + this.G.x) / 3.0, (this.b003.y + this.b030.y + this.G.y) / 3.0, (this.b003.z + this.b030.z + this.G.z) / 3.0);
        e1 = Bezier2.normalizeVect(this.getNormal(0.5, 0.5));
        e2 = Bezier2.normalizeVect(Bezier2.countDifferenceProduct(this.b012, this.b021));
        normalOfPlane = Bezier2.setNormalVector(Bezier2.countCrossProduct(e1, e2), e2);
        this.B111 = new Coordinate(this.countProjectOnToPlane(this.b012, normalOfPlane, this.B111, normalOfT));
        this.C111 = new Coordinate((this.b003.x + this.b300.x + this.G.x) / 3.0, (this.b003.y + this.b300.y + this.G.y) / 3.0, (this.b003.z + this.b300.z + this.G.z) / 3.0);
        e1 = Bezier2.normalizeVect(this.getNormal(0.0, 0.5));
        e2 = Bezier2.normalizeVect(Bezier2.countDifferenceProduct(this.b201, this.b102));
        normalOfPlane = Bezier2.setNormalVector(Bezier2.countCrossProduct(e1, e2), e2);
        this.C111 = new Coordinate(this.countProjectOnToPlane(this.b201, normalOfPlane, this.C111, normalOfT));
        this.A201 = new Coordinate((this.b300.x + this.b210.x + this.b201.x) / 3.0, (this.b300.y + this.b210.y + this.b201.y) / 3.0, (this.b300.z + this.b210.z + this.b201.z) / 3.0);
        this.A021 = new Coordinate((this.b030.x + this.b120.x + this.b021.x) / 3.0, (this.b030.y + this.b120.y + this.b021.y) / 3.0, (this.b030.z + this.b120.z + this.b021.z) / 3.0);
        this.B102 = new Coordinate((this.b012.x + this.b102.x + this.b003.x) / 3.0, (this.b012.y + this.b102.y + this.b003.y) / 3.0, (this.b012.z + this.b102.z + this.b003.z) / 3.0);
        this.A102 = new Coordinate((this.A111.x + this.A201.x + this.C111.x) / 3.0, (this.A111.y + this.A201.y + this.C111.y) / 3.0, (this.A111.z + this.A201.z + this.C111.z) / 3.0);
        this.A012 = new Coordinate((this.B111.x + this.A021.x + this.A111.x) / 3.0, (this.B111.y + this.A021.y + this.A111.y) / 3.0, (this.B111.z + this.A021.z + this.A111.z) / 3.0);
        this.B201 = new Coordinate((this.C111.x + this.B111.x + this.B102.x) / 3.0, (this.C111.y + this.B111.y + this.B102.y) / 3.0, (this.C111.z + this.B111.z + this.B102.z) / 3.0);
        this.G = new Coordinate((this.A102.x + this.A012.x + this.B201.x) / 3.0, (this.A102.y + this.A012.y + this.B201.y) / 3.0, (this.A102.z + this.A012.z + this.B201.z) / 3.0);
    }

    protected void printToConsole() {
        System.out.println("=========MACRO TRIANGLE=============================");
        System.out.println(this.b300.toString());
        System.out.println(this.b030.toString());
        System.out.println(this.b003.toString());
        System.out.println("Normals:");
        if (this.normalN1 != null) {
            System.out.println(this.normalN1.toString());
            System.out.println(this.normalN2.toString());
            System.out.println(this.normalN3.toString());
            System.out.println("Koeficients");
            System.out.println(this.b012.toString());
            System.out.println(this.b021.toString());
            System.out.println(this.b102.toString());
            System.out.println(this.b120.toString());
            System.out.println(this.b210.toString());
            System.out.println(this.b201.toString());
        }
        System.out.println("======================================");
    }

    protected Envelope getEnvelope() {
        Coordinate[] newPoint = new Coordinate[]{this.b003, this.b030, this.b300, this.b003};
        CoordinateArraySequence newPointsTriangle = new CoordinateArraySequence(newPoint);
        LinearRing trianglesPoints = new LinearRing((CoordinateSequence)newPointsTriangle, new GeometryFactory());
        return trianglesPoints.getEnvelopeInternal();
    }

    protected Bezier getBezierPatch(int index) {
        switch (index) {
            case 0: {
                return new Bezier(this.b300, this.b030, this.G, this.b210, this.b120, this.A021, this.A012, this.A102, this.A201, this.A111);
            }
            case 1: {
                return new Bezier(this.b030, this.b003, this.G, this.b021, this.b012, this.B102, this.B201, this.A012, this.A021, this.B111);
            }
            case 2: {
                return new Bezier(this.b003, this.b300, this.G, this.b102, this.b201, this.A201, this.A102, this.B201, this.B102, this.C111);
            }
        }
        return null;
    }
}

