/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.smoothTinBezier;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class TriangleDT
implements Serializable {
    public Coordinate A;
    public Coordinate B;
    public Coordinate C;
    public boolean haveBreakLine = false;
    public int typeBreakLine = -1;

    public TriangleDT(TriangleDT T) {
        this.A = T.A;
        this.B = T.B;
        this.C = T.C;
    }

    public TriangleDT(Coordinate A, Coordinate B, Coordinate C) {
        this.A = A;
        this.B = B;
        this.C = C;
    }

    public TriangleDT(Coordinate[] coords) {
        this.A = new Coordinate(coords[0].x, coords[0].y, coords[0].z);
        this.B = new Coordinate(coords[1].x, coords[1].y, coords[1].z);
        this.C = new Coordinate(coords[2].x, coords[2].y, coords[2].z);
    }

    public TriangleDT() {
    }

    public boolean containsLine(LineString newL) {
        Coordinate[] newPoints = new Coordinate[]{this.A, this.B, this.C, this.A};
        CoordinateArraySequence newPointsTriangle = new CoordinateArraySequence(newPoints);
        LinearRing trianglesPoints = new LinearRing((CoordinateSequence)newPointsTriangle, new GeometryFactory());
        return newL.crosses(trianglesPoints.convexHull());
    }

    protected Coordinate getCentroid() {
        return new Coordinate((this.A.x + this.B.x + this.C.x) / 3.0, (this.A.y + this.B.y + this.C.y) / 3.0);
    }

    public boolean contains(Coordinate P) {
        GeneralPath triangle = new GeneralPath();
        triangle.moveTo((float)this.A.x, (float)this.A.y);
        triangle.lineTo((float)this.B.x, (float)this.B.y);
        triangle.lineTo((float)this.C.x, (float)this.C.y);
        triangle.lineTo((float)this.A.x, (float)this.A.y);
        triangle.closePath();
        return triangle.contains(P.x, P.y);
    }

    public boolean containsPointAsVertex(Coordinate P) {
        return this.A.equals2D(P) || this.B.equals2D(P) || this.C.equals2D(P);
    }

    protected boolean containsOneSamePointWith(TriangleDT T) {
        if (T.A.equals2D(this.A) || T.A.equals2D(this.B) || T.A.equals2D(this.C)) {
            return true;
        }
        if (T.B.equals2D(this.A) || T.B.equals2D(this.B) || T.B.equals2D(this.C)) {
            return true;
        }
        return T.C.equals2D(this.A) || T.C.equals2D(this.B) || T.C.equals2D(this.C);
    }

    public boolean containsTwoPoints(Coordinate P1, Coordinate P2) {
        return !(!this.A.equals2D(P1) && !this.B.equals2D(P1) && !this.C.equals2D(P1) || !this.A.equals2D(P2) && !this.B.equals2D(P2) && !this.C.equals2D(P2));
    }

    protected boolean isTriangle() {
        Coordinate[] newPoint = new Coordinate[]{this.A, this.B, this.C, this.A};
        CoordinateArraySequence newPointsTriangle = new CoordinateArraySequence(newPoint);
        LinearRing trianglesPoints = new LinearRing((CoordinateSequence)newPointsTriangle, new GeometryFactory());
        return trianglesPoints.convexHull().getGeometryType() == "Polygon";
    }

    public boolean compare(TriangleDT T) {
        return !(!T.A.equals2D(this.A) && !T.A.equals2D(this.B) && !T.A.equals2D(this.C) || !T.B.equals2D(this.A) && !T.B.equals2D(this.B) && !T.B.equals2D(this.C) || !T.C.equals2D(this.A) && !T.C.equals2D(this.B) && !T.C.equals2D(this.C));
    }

    public char compareReturnIndex(Coordinate P) {
        if (P.equals2D(this.A)) {
            return 'A';
        }
        if (P.equals2D(this.B)) {
            return 'B';
        }
        if (P.equals2D(this.C)) {
            return 'C';
        }
        return 'N';
    }

    public Envelope getEnvelope() {
        Coordinate[] newPoint = new Coordinate[]{this.A, this.B, this.C, this.A};
        CoordinateArraySequence newPointsTriangle = new CoordinateArraySequence(newPoint);
        LinearRing trianglesPoints = new LinearRing((CoordinateSequence)newPointsTriangle, new GeometryFactory());
        return trianglesPoints.getEnvelopeInternal();
    }

    public void normalizePolygon() {
        Coordinate[] coords = new Coordinate[4];
        GeometryFactory gf = new GeometryFactory();
        coords[0] = this.A;
        coords[1] = this.B;
        coords[2] = this.C;
        coords[3] = this.A;
        LinearRing ring = gf.createLinearRing(coords);
        Polygon poly = gf.createPolygon(ring, null);
        poly.normalize();
        coords = poly.getCoordinates();
        this.A = coords[0];
        this.B = coords[1];
        this.C = coords[2];
    }
}

