/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.topology.checkLineDirectionCoherence;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckLineDirectionCoherenceAlgorithm
extends GeoAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(CheckLineDirectionCoherenceAlgorithm.class);
    public static final String RESULT = "RESULT";
    public static final String LINES = "LINES";
    public static final String FIELD = "FIELD";
    private static final String TOLERANCE = "TOLERANCE";
    private IVectorLayer m_Lines;
    private IVectorLayer m_Output;
    private double m_dTolerance;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"CheckLineDirectionCoherence"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines_layer"), 1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LINES);
            this.m_Parameters.addNumericalValue(TOLERANCE, Sextante.getText((String)"Tolerance"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            LOG.error("Repeated parameter name", (Throwable)e);
            return;
        }
        catch (UndefinedParentParameterNameException e) {
            LOG.error("Undefined parameter name", (Throwable)e);
            return;
        }
        catch (OptionalParentParameterException e) {
            LOG.error("Optional parent parameter", (Throwable)e);
            return;
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        HashMap map = new HashMap();
        HashMap<String, ArrayList<IFeature>> classes = new HashMap<String, ArrayList<IFeature>>();
        this.m_Lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            this.m_Lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE);
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_Lines.getName(), this.m_Lines.getShapeType(), this.m_Lines.getFieldTypes(), this.m_Lines.getFieldNames());
        int iShapesCount = this.m_Lines.getShapesCount();
        IFeatureIterator iter = this.m_Lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapesCount)) {
            IFeature feature = iter.next();
            String sClass = feature.getRecord().getValue(iField).toString();
            ArrayList<IFeature> features = (ArrayList<IFeature>)classes.get(sClass);
            if (features == null) {
                features = new ArrayList<IFeature>();
                classes.put(sClass, features);
            }
            features.add(feature);
            ++i;
        }
        iter.close();
        Set set = classes.keySet();
        Iterator keys = set.iterator();
        i = 0;
        while (keys.hasNext() && this.setProgress(i, classes.size())) {
            Object sClass = keys.next();
            ArrayList lines = (ArrayList)classes.get(sClass);
            this.processLines(lines);
        }
        return !this.m_Task.isCanceled();
    }

    private void processLines(ArrayList<IFeature> lines) {
        BitSet bitset = new BitSet(lines.size());
        while (bitset.cardinality() != bitset.length() || bitset.isEmpty()) {
            IFeature line = this.getExtremeLine(lines, bitset);
            this.m_Output.addFeature(line);
            this.followLine(line, lines, bitset);
        }
        for (int i = 0; i < lines.size(); ++i) {
            if (bitset.get(i)) continue;
            IFeature line = lines.get(i);
            this.m_Output.addFeature(line);
        }
    }

    private void followLine(IFeature feature, ArrayList<IFeature> lines, BitSet bitset) {
        Coordinate[] coords2;
        Geometry line2;
        IFeature feature2;
        int j;
        Coordinate[] coords;
        int i;
        Geometry line = feature.getGeometry();
        for (i = 0; i < lines.size(); ++i) {
            if (bitset.get(i)) continue;
            coords = line.getCoordinates();
            for (j = 0; j < lines.size(); ++j) {
                feature2 = lines.get(j);
                line2 = feature2.getGeometry();
                coords2 = line2.getCoordinates();
                if (bitset.get(j) || line.equals(line2) || !(coords2[0].distance(coords[coords.length - 1]) < this.m_dTolerance)) continue;
                this.m_Output.addFeature(feature2);
                bitset.set(j);
                this.followLine(feature2, lines, bitset);
            }
        }
        for (i = 0; i < lines.size(); ++i) {
            if (bitset.get(i)) continue;
            coords = line.getCoordinates();
            for (j = 0; j < lines.size(); ++j) {
                feature2 = lines.get(j);
                line2 = feature2.getGeometry();
                coords2 = line2.getCoordinates();
                if (bitset.get(j) || line.equals(line2) || !(coords2[coords2.length - 1].distance(coords[coords.length - 1]) < this.m_dTolerance)) continue;
                Geometry inverted = this.invertDirection(feature.getGeometry());
                this.m_Output.addFeature(inverted, feature2.getRecord().getValues());
                bitset.set(j);
                this.followLine(lines.get(j), lines, bitset);
            }
        }
    }

    private Geometry invertDirection(Geometry geometry) {
        Coordinate[] coords = geometry.getCoordinates();
        Coordinate[] newCoords = new Coordinate[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            newCoords[i] = coords[coords.length - i - 1];
        }
        GeometryFactory gf = new GeometryFactory();
        return gf.createLineString(newCoords);
    }

    private IFeature getExtremeLine(ArrayList<IFeature> lines, BitSet bitset) {
        int i;
        for (i = 0; i < lines.size(); ++i) {
            if (bitset.get(i)) continue;
            Geometry line = lines.get(i).getGeometry();
            Coordinate[] coords = line.getCoordinates();
            boolean bHasContiguousLineOnStart = false;
            for (int j = 0; j < lines.size(); ++j) {
                Geometry line2 = lines.get(j).getGeometry();
                Coordinate[] coords2 = line2.getCoordinates();
                if (i == j || !(coords2[0].distance(coords[0]) < this.m_dTolerance) && !(coords2[coords2.length - 1].distance(coords[0]) < this.m_dTolerance)) continue;
                bHasContiguousLineOnStart = true;
                break;
            }
            boolean bHasContiguousLineOnEnd = false;
            for (int j = 0; j < lines.size(); ++j) {
                Geometry line2 = lines.get(j).getGeometry();
                Coordinate[] coords2 = line2.getCoordinates();
                if (i == j || !(coords2[0].distance(coords[coords.length - 1]) < this.m_dTolerance) && !(coords2[coords2.length - 1].distance(coords[coords.length - 1]) < this.m_dTolerance)) continue;
                bHasContiguousLineOnEnd = true;
                break;
            }
            if (bHasContiguousLineOnEnd == bHasContiguousLineOnStart) continue;
            bitset.set(i);
            return lines.get(i);
        }
        for (i = 0; i < lines.size(); ++i) {
            if (bitset.get(i)) continue;
            bitset.set(i);
            return lines.get(i);
        }
        return null;
    }
}

