/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.topology.extractNodes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.topology.extractNodes.Node;
import java.util.HashMap;
import java.util.Iterator;

public class ExtractNodesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Extract_Nodes"));
        this.setGroup(Sextante.getText((String)"Topology"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Capa de entrada"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Nodes"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] out_ftypes = new Class[]{Integer.class};
        String[] out_fnames = new String[]{"DEGREE"};
        IVectorLayer driver = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Nodes"), 0, out_ftypes, out_fnames);
        HashMap nodesHashMap = new HashMap();
        GeometryFactory gf = new GeometryFactory();
        int count = 0;
        int idx = 0;
        int iTotal = layerIn.getShapesCount();
        IFeatureIterator iter = layerIn.iterator();
        idx = 0;
        while (iter.hasNext() && this.setProgress(count, iTotal)) {
            IFeature feature = iter.next();
            Coordinate[] coords = feature.getGeometry().getCoordinates();
            Point point = gf.createPoint(coords[0]);
            this.processNode(nodesHashMap, (Geometry)point, count, feature, idx);
            point = gf.createPoint(coords[coords.length - 1]);
            this.processNode(nodesHashMap, (Geometry)point, ++count, feature, idx);
            this.setProgress(count, iTotal);
            ++idx;
        }
        iter.close();
        Iterator nodesIter = nodesHashMap.values().iterator();
        while (nodesIter.hasNext() && this.setProgress(i, iTotal)) {
            Node n = (Node)nodesIter.next();
            Geometry g = n.getGeometry();
            Object[] values = new Object[]{n.getDegree()};
            driver.addFeature(g, values);
            this.setProgress(i, iTotal);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void processNode(HashMap endpoints, Geometry point, int count, IFeature feat, int featIdx) {
        if (!endpoints.containsKey(point.toText())) {
            Node node = new Node(count, point, feat);
            node.addConnectedLine(feat, featIdx);
            endpoints.put(point.toText(), node);
        } else {
            Node ep = (Node)endpoints.get(point.toText());
            ep.incrementDegree();
            ep.addConnectedLine(feat, featIdx);
        }
    }
}

