/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.topology.nodeLines;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class NodeLinesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LINES = "LINES";
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Node_lines"));
        this.setGroup(Sextante.getText((String)"Topology"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Lines"), 1, LINES);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Geometry geom;
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, lines.getFieldTypes(), lines.getFieldNames());
        int i = 0;
        int iShapeCount = lines.getShapesCount();
        IFeatureIterator iter = lines.iterator();
        IFeature feature = iter.next();
        Geometry merged = geom = feature.getGeometry();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            feature = iter.next();
            geom = feature.getGeometry();
            merged.union(geom);
            ++i;
        }
        iter.close();
        i = 0;
        iter = lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            feature = iter.next();
            this.m_Output.addFeature(merged.getGeometryN(i), feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

