/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tridimensional.grid3DFromFunction;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.nfunk.jep.JEP;

public class Grid3DFromFunctionAlgorithm
extends GeoAlgorithm {
    public static final String MINX = "MINX";
    public static final String MINY = "MINY";
    public static final String MINZ = "MINZ";
    public static final String MAXX = "MAXX";
    public static final String MAXY = "MAXY";
    public static final String MAXZ = "MAXZ";
    public static final String FORMULA = "FORMULA";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        jep.addVariable("x", 0.0);
        jep.addVariable("y", 0.0);
        jep.addVariable("z", 0.0);
        double dMinX = this.m_Parameters.getParameterValueAsInt(MINX);
        double dMinY = this.m_Parameters.getParameterValueAsInt(MINY);
        double dMinZ = this.m_Parameters.getParameterValueAsInt(MINY);
        double dMaxX = this.m_Parameters.getParameterValueAsInt(MAXX);
        double dMaxY = this.m_Parameters.getParameterValueAsInt(MAXY);
        double dMaxZ = this.m_Parameters.getParameterValueAsInt(MAXZ);
        String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA).toLowerCase();
        double dRangeX = dMaxX - dMinX;
        double dRangeY = dMaxY - dMinY;
        double dRangeZ = dMaxZ - dMinZ;
        I3DRasterLayer result = this.getNew3DRasterLayer(RESULT, Sextante.getText((String)"3D_Layer_from_function"), 4);
        int iNX = result.getLayerExtent().getNX();
        int iNY = result.getLayerExtent().getNY();
        int iNZ = result.getLayerExtent().getNZ();
        jep.parseExpression(sFormula);
        if (!jep.hasError()) {
            for (int z = 0; z < iNZ && this.setProgress(z, iNZ); ++z) {
                double dz = dMinZ + dRangeZ * ((double)z / (double)iNZ);
                jep.addVariable("z", dz);
                for (int y = 0; y < iNY && !this.m_Task.isCanceled(); ++y) {
                    double dy = dMinY + dRangeY * ((double)y / (double)iNY);
                    jep.addVariable("y", dy);
                    for (int x = 0; x < iNX; ++x) {
                        double dx = dMinX + dRangeX * ((double)x / (double)iNX);
                        jep.addVariable("x", dx);
                        double dValue = jep.getValue();
                        result.setCellValue(x, y, z, dValue);
                    }
                }
            }
        } else {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_formula"));
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"3D_Layer_from_function"));
        this.setGroup(Sextante.getText((String)"3D"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addNumericalValue(MINX, "X min", -1.0, 2);
            this.m_Parameters.addNumericalValue(MAXX, "X Max", 1.0, 2);
            this.m_Parameters.addNumericalValue(MINY, "Y Min", -1.0, 2);
            this.m_Parameters.addNumericalValue(MAXY, "Y Max", 1.0, 2);
            this.m_Parameters.addNumericalValue(MINZ, "Z Min", -1.0, 2);
            this.m_Parameters.addNumericalValue(MAXZ, "Z Max", 1.0, 2);
            this.m_Parameters.addString(FORMULA, Sextante.getText((String)"Formula"));
            this.addOutput3DRasterLayer(RESULT, Sextante.getText((String)"3D_Layer_from_function"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean is3D() {
        return true;
    }

    public boolean isActive() {
        return false;
    }
}

