/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.InPolygonSpatialJoin;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.LayerCannotBeOverwrittenException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.vectorTools.InPolygonSpatialJoin.SpatialJoinTableModel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class InPolygonSpatialJoinParametersPanel
extends GeoAlgorithmParametersPanel {
    private GeoAlgorithm m_Algorithm;
    private JLabel jLabelGroupings;
    private JTable jTableGroupings;
    private JComboBox jComboBoxPolygonLayers;
    private JComboBox jComboBoxPointsLayers;
    private JLabel jLabelPointsLayer;
    private JLabel jLabelPolygonsLayer;
    private JScrollPane jScrollPaneGroupings;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    public void assignParameters() throws WrongInputException, LayerCannotBeOverwrittenException {
        OverwriteOutputChannel ooc;
        IOutputChannel channel;
        Output out;
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxPolygonLayers.getSelectedItem();
        IVectorLayer polygonLayer = (IVectorLayer)oad.getObject();
        ParametersSet params = this.m_Algorithm.getParameters();
        try {
            params.getParameter("POLYGONS").setParameterValue((Object)polygonLayer);
            oad = (ObjectAndDescription)this.jComboBoxPointsLayers.getSelectedItem();
            IVectorLayer pointsLayer = (IVectorLayer)oad.getObject();
            params.getParameter("POINTS").setParameterValue((Object)pointsLayer);
            SpatialJoinTableModel model = (SpatialJoinTableModel)this.jTableGroupings.getModel();
            params.getParameter("GROUPING_FUNCTIONS").setParameterValue((Object)model.getAsString());
        }
        catch (Exception e) {
            throw new WrongInputException();
        }
        OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
        try {
            out = ooSet.getOutput("RESULT");
            channel = this.outputChannelSelectionPanel.getOutputChannel();
        }
        catch (Exception e) {
            throw new WrongInputException();
        }
        if (channel instanceof OverwriteOutputChannel && !(ooc = (OverwriteOutputChannel)channel).getLayer().canBeEdited()) {
            throw new LayerCannotBeOverwrittenException();
        }
        out.setOutputChannel(channel);
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, -1.0, 5.0}, {5.0, 25.0, 5.0, 25.0, 5.0, 25.0, -1.0, 5.0, 20.0, 5.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(469, 257));
            this.jLabelGroupings = new JLabel();
            this.add(this.jLabelGroupings, "1, 5");
            this.jLabelGroupings.setText(Sextante.getText((String)"Summary_statistics"));
            this.jScrollPaneGroupings = new JScrollPane();
            this.jScrollPaneGroupings.setHorizontalScrollBarPolicy(30);
            this.add(this.jScrollPaneGroupings, "1, 6, 2, 6");
            this.jTableGroupings = new JTable();
            this.jScrollPaneGroupings.setViewportView(this.jTableGroupings);
            this.jLabelPolygonsLayer = new JLabel();
            this.add(this.jLabelPolygonsLayer, "1, 1");
            this.jLabelPolygonsLayer.setText(Sextante.getText((String)"Polygons"));
            this.jLabelPointsLayer = new JLabel();
            this.add(this.jLabelPointsLayer, "1, 3");
            this.jLabelPointsLayer.setText(Sextante.getText((String)"Secondary_layer"));
            DefaultComboBoxModel<ObjectAndDescription> jComboBoxPointsLayersModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getVectorLayers());
            this.jComboBoxPointsLayers = new JComboBox();
            this.add(this.jComboBoxPointsLayers, "2, 3");
            this.jComboBoxPointsLayers.setModel(jComboBoxPointsLayersModel);
            this.jComboBoxPointsLayers.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InPolygonSpatialJoinParametersPanel.this.setTableModel();
                }
            });
            this.jComboBoxPointsLayers.setSelectedIndex(0);
            this.setTableModel();
            DefaultComboBoxModel<ObjectAndDescription> jComboBoxPolygonLayersModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getPolygonLayers());
            this.jComboBoxPolygonLayers = new JComboBox();
            this.add(this.jComboBoxPolygonLayers, "2, 1");
            this.jComboBoxPolygonLayers.setModel(jComboBoxPolygonLayersModel);
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
            this.add((Component)this.outputChannelSelectionPanel, "2,8");
            this.add(new JLabel(Sextante.getText((String)"Result")), "1,8");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void setTableModel() {
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxPointsLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        SpatialJoinTableModel tableModel = new SpatialJoinTableModel(layer);
        this.jTableGroupings.setModel(tableModel);
    }

    private ObjectAndDescription[] getPolygonLayers() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(2);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    private ObjectAndDescription[] getVectorLayers() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    public void setOutputValue(String sOutputName, String sValue) {
        this.outputChannelSelectionPanel.setText(sValue);
    }

    public void setParameterValue(String parameterName, String value) {
    }
}

