/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.autoincrementValue;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class AutoincrementValueAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String FIELD = "FIELD";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        IVectorLayer result = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Autoincrement_Value"), layerIn.getShapeType(), layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int iTotal = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            IRecord record = feature.getRecord();
            Object[] values = record.getValues();
            values[iField] = i;
            result.addFeature(feature.getGeometry(), values);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Autoincrement_Value"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Attribute"), LAYER);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Autoincrement_Value"), -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

