/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.dissolveMultiple;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.LayerCannotBeOverwrittenException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.vectorTools.dissolveMultiple.DissolveTableModel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.japura.gui.Anchor;
import org.japura.gui.BatchSelection;
import org.japura.gui.CheckComboBox;
import org.japura.gui.EmbeddedComponent;
import org.japura.gui.model.ListCheckModel;

public class DissolveMultipleParametersPanel
extends GeoAlgorithmParametersPanel {
    private GeoAlgorithm m_Algorithm;
    private JLabel jLabelGroupings;
    private CheckComboBox fieldsBox;
    private JTable jTableGroupings;
    private JComboBox jComboBoxLayers;
    private JLabel jLabelField;
    private JLabel jLabelLayer;
    private JScrollPane jScrollPaneFields;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    public void assignParameters() throws WrongInputException, LayerCannotBeOverwrittenException {
        OverwriteOutputChannel ooc;
        IOutputChannel channel;
        Output out;
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        ParametersSet params = this.m_Algorithm.getParameters();
        try {
            params.getParameter("LAYER").setParameterValue((Object)layer);
            StringBuffer sb = new StringBuffer();
            List selected = this.fieldsBox.getModel().getCheckeds();
            for (int i = 0; i < selected.size(); ++i) {
                if (i == 0) {
                    sb.append(selected.get(i).toString());
                    continue;
                }
                sb.append("," + selected.get(i).toString());
            }
            params.getParameter("GROUPING_FIELD").setParameterValue((Object)sb.toString());
            DissolveTableModel model = (DissolveTableModel)this.jTableGroupings.getModel();
            params.getParameter("GROUPING_FUNCTIONS").setParameterValue((Object)model.getAsString());
        }
        catch (WrongParameterIDException e) {
            throw new WrongInputException();
        }
        try {
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            out = ooSet.getOutput("RESULT");
            channel = this.outputChannelSelectionPanel.getOutputChannel();
        }
        catch (Exception e) {
            throw new WrongInputException();
        }
        if (channel instanceof OverwriteOutputChannel && !(ooc = (OverwriteOutputChannel)channel).getLayer().canBeEdited()) {
            throw new LayerCannotBeOverwrittenException();
        }
        out.setOutputChannel(channel);
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, -1.0, 5.0}, {5.0, 25.0, 5.0, 25.0, 5.0, 25.0, -1.0, 5.0, 20.0, 5.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(469, 257));
            this.jLabelGroupings = new JLabel();
            this.add(this.jLabelGroupings, "1, 5");
            this.jLabelGroupings.setText(Sextante.getText((String)"Summary_statistics"));
            this.jScrollPaneFields = new JScrollPane();
            this.jScrollPaneFields.setHorizontalScrollBarPolicy(30);
            this.add(this.jScrollPaneFields, "1, 6, 2, 6");
            this.jTableGroupings = new JTable();
            this.jScrollPaneFields.setViewportView(this.jTableGroupings);
            this.jLabelLayer = new JLabel();
            this.add(this.jLabelLayer, "1, 1");
            this.jLabelLayer.setText(Sextante.getText((String)"Layer"));
            this.jLabelField = new JLabel();
            this.add(this.jLabelField, "1, 3");
            this.jLabelField.setText(Sextante.getText((String)"Fields"));
            this.fieldsBox = new CheckComboBox();
            this.fieldsBox.setTextFor(CheckComboBox.NONE, Sextante.getText((String)"no_elements_selected"));
            this.fieldsBox.setTextFor(CheckComboBox.MULTIPLE, Sextante.getText((String)"multiple_elements_selected"));
            BatchSelection.CheckBox bs = new BatchSelection.CheckBox();
            EmbeddedComponent comp = new EmbeddedComponent((JComponent)bs, Anchor.NORTH);
            this.fieldsBox.setEmbeddedComponent(comp);
            this.add((Component)this.fieldsBox, "2, 3");
            DefaultComboBoxModel<ObjectAndDescription> jComboBoxLayersModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayers());
            this.jComboBoxLayers = new JComboBox();
            this.add(this.jComboBoxLayers, "2, 1");
            this.jComboBoxLayers.setModel(jComboBoxLayersModel);
            this.jComboBoxLayers.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DissolveMultipleParametersPanel.this.setFields();
                    DissolveMultipleParametersPanel.this.setTableModel();
                }
            });
            this.jComboBoxLayers.setSelectedIndex(0);
            this.setFields();
            this.setTableModel();
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
            this.add((Component)this.outputChannelSelectionPanel, "2,8");
            this.add(new JLabel(Sextante.getText((String)"Result")), "1,8");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void setFields() {
        String[] fields = this.getFields();
        ListCheckModel model = this.fieldsBox.getModel();
        model.clear();
        for (String obj : fields) {
            model.addElement(new Object[]{obj});
        }
        this.fieldsBox.setModel(model);
    }

    private void setTableModel() {
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        DissolveTableModel tableModel = new DissolveTableModel(layer);
        this.jTableGroupings.setModel(tableModel);
    }

    private String[] getFields() {
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        return this.getFields(layer);
    }

    private String[] getFields(IVectorLayer layer) {
        return layer.getFieldNames();
    }

    private ObjectAndDescription[] getLayers() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    public void setOutputValue(String sOutputName, String sValue) {
        this.outputChannelSelectionPanel.setText(sValue);
    }

    public void setParameterValue(String parameterName, String value) {
    }
}

