/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.exportVector;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.Output;

public class ExportVectorAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        Output out = this.m_OutputObjects.getOutput(RESULT);
        String sFilename = ((FileOutputChannel)out.getOutputChannel()).getFilename();
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        if (sFilename != null) {
            IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), layer.getShapeType(), layer.getFieldTypes(), layer.getFieldNames());
            int iShapeCount = layer.getShapesCount();
            int i = 0;
            IFeatureIterator iter = layer.iterator();
            while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                IFeature feature = iter.next();
                output.addFeature(feature);
                ++i;
            }
            try {
                output.postProcess();
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
        }
        out = this.m_OutputObjects.getOutput(RESULT);
        out.setOutputObject(null);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Export_vector_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean isSuitableForModelling() {
        return false;
    }
}

