/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.lineAverageSlope;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.util.ArrayList;

public class LineAverageSlopeAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String DISTANCE = "DISTANCE";
    public static final String DEM = "DEM";
    public static final String LINES = "LINES";
    private static final double NODATA = -99999.0;
    private IVectorLayer m_Output;
    private double m_dDist;
    private IRasterLayer m_DEM;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        try {
            this.m_dDist = this.m_Parameters.getParameterValueAsDouble(DISTANCE);
            IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
            this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
            this.m_DEM.setFullExtent();
            if (!this.m_bIsAutoExtent) {
                lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            }
            Class[] types = new Class[lines.getFieldCount() + 2];
            String[] sFields = new String[lines.getFieldCount() + 2];
            types[lines.getFieldCount()] = Double.class;
            sFields[lines.getFieldCount()] = Sextante.getText((String)"Slope");
            types[lines.getFieldCount() + 1] = Double.class;
            sFields[lines.getFieldCount() + 1] = "Max " + Sextante.getText((String)"Slope");
            for (int j = 0; j < lines.getFieldCount(); ++j) {
                sFields[j] = lines.getFieldName(j);
                types[j] = lines.getFieldType(j);
            }
            this.m_Output = this.getNewVectorLayer(RESULT, lines.getName() + "[" + Sextante.getText((String)"Slope") + "]", 1, types, sFields);
            int i = 0;
            int iShapeCount = lines.getShapesCount();
            IFeatureIterator iter = lines.iterator();
            while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                SimpleStats stats = this.getSlopeStats(geom);
                Object[] orgValues = feature.getRecord().getValues();
                Object[] values = new Object[orgValues.length + 2];
                System.arraycopy(orgValues, 0, values, 0, orgValues.length);
                values[orgValues.length] = stats.getMean();
                values[orgValues.length + 1] = stats.getMax();
                this.m_Output.addFeature(geom, values);
                ++i;
            }
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
        return !this.m_Task.isCanceled();
    }

    private SimpleStats getSlopeStats(Geometry geom) {
        double dDist;
        double dY1;
        double dX1;
        double dRemainingDistFromLastSegment = 0.0;
        Coordinate[] coords = geom.getCoordinates();
        ArrayList<Point> points = new ArrayList<Point>();
        GeometryFactory gf = new GeometryFactory();
        double dAddedPointX = dX1 = coords[0].x;
        double dAddedPointY = dY1 = coords[0].y;
        Point point = gf.createPoint(new Coordinate(dAddedPointX, dAddedPointY));
        points.add(point);
        for (int i = 0; i < coords.length - 1; ++i) {
            double dX2 = coords[i + 1].x;
            dX1 = coords[i].x;
            double dDX = dX2 - dX1;
            double dY2 = coords[i + 1].y;
            dY1 = coords[i].y;
            double dDY = dY2 - dY1;
            double dDistToNextPoint = Math.sqrt(dDX * dDX + dDY * dDY);
            if (dRemainingDistFromLastSegment + dDistToNextPoint > this.m_dDist) {
                int iPoints = (int)((dRemainingDistFromLastSegment + dDistToNextPoint) / this.m_dDist);
                dDist = this.m_dDist - dRemainingDistFromLastSegment;
                for (int j = 0; j < iPoints; ++j) {
                    dDist = this.m_dDist - dRemainingDistFromLastSegment;
                    dAddedPointX = dX1 + (dDist += (double)j * this.m_dDist) * dDX / dDistToNextPoint;
                    dAddedPointY = dY1 + dDist * dDY / dDistToNextPoint;
                    point = gf.createPoint(new Coordinate(dAddedPointX, dAddedPointY));
                    points.add(point);
                }
                dDX = dX2 - dAddedPointX;
                dDY = dY2 - dAddedPointY;
                dRemainingDistFromLastSegment = Math.sqrt(dDX * dDX + dDY * dDY);
                continue;
            }
            dRemainingDistFromLastSegment += dDistToNextPoint;
        }
        SimpleStats stats = new SimpleStats();
        for (int k = 0; k < points.size() - 1; ++k) {
            point = (Point)points.get(k);
            double dElevation = this.m_DEM.getValueAt(point.getX(), point.getY());
            Point point2 = (Point)points.get(k + 1);
            double dElevation2 = this.m_DEM.getValueAt(point2.getX(), point2.getY());
            dDist = Math.sqrt(Math.pow(point.getX() - point2.getX(), 2.0) + Math.pow(point.getY() - point2.getY(), 2.0));
            double dSlope = Math.abs((dElevation2 - dElevation) / dDist);
            stats.addValue(dSlope);
        }
        return stats;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Average_slope_line"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.m_Parameters.addNumericalValue(DISTANCE, Sextante.getText((String)"Distance_between_points"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)DEM), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

