/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.linesToEquispacedPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class LinesToEquispacedPointsAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String DISTANCE = "DISTANCE";
    public static final String LINES = "LINES";
    private IVectorLayer m_Output;
    private double m_dDist;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        try {
            this.m_dDist = this.m_Parameters.getParameterValueAsDouble(DISTANCE);
            IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
            if (!this.m_bIsAutoExtent) {
                lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            }
            this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Points") + "(" + lines.getName() + ")", 0, lines.getFieldTypes(), lines.getFieldNames());
            int i = 0;
            int iShapeCount = lines.getShapesCount();
            IFeatureIterator iter = lines.iterator();
            while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                for (int j = 0; j < geom.getNumGeometries(); ++j) {
                    Geometry subgeom = geom.getGeometryN(j);
                    this.processLine(subgeom, feature.getRecord().getValues());
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
        return !this.m_Task.isCanceled();
    }

    private void processLine(Geometry geom, Object[] record) {
        double dY1;
        double dX1;
        double dRemainingDistFromLastSegment = 0.0;
        Coordinate[] coords = geom.getCoordinates();
        if (coords.length == 0) {
            return;
        }
        GeometryFactory gf = new GeometryFactory();
        double dAddedPointX = dX1 = coords[0].x;
        double dAddedPointY = dY1 = coords[0].y;
        Point point = gf.createPoint(new Coordinate(dAddedPointX, dAddedPointY));
        this.m_Output.addFeature((Geometry)point, record);
        for (int i = 0; i < coords.length - 1; ++i) {
            double dX2 = coords[i + 1].x;
            dX1 = coords[i].x;
            double dDX = dX2 - dX1;
            double dY2 = coords[i + 1].y;
            dY1 = coords[i].y;
            double dDY = dY2 - dY1;
            double dDistToNextPoint = Math.sqrt(dDX * dDX + dDY * dDY);
            if (dRemainingDistFromLastSegment + dDistToNextPoint > this.m_dDist) {
                int iPoints = (int)((dRemainingDistFromLastSegment + dDistToNextPoint) / this.m_dDist);
                double dDist = this.m_dDist - dRemainingDistFromLastSegment;
                for (int j = 0; j < iPoints; ++j) {
                    dDist = this.m_dDist - dRemainingDistFromLastSegment;
                    dAddedPointX = dX1 + (dDist += (double)j * this.m_dDist) * dDX / dDistToNextPoint;
                    dAddedPointY = dY1 + dDist * dDY / dDistToNextPoint;
                    point = gf.createPoint(new Coordinate(dAddedPointX, dAddedPointY));
                    this.m_Output.addFeature((Geometry)point, record);
                }
                dDX = dX2 - dAddedPointX;
                dDY = dY2 - dAddedPointY;
                dRemainingDistFromLastSegment = Math.sqrt(dDX * dDX + dDY * dDY);
                continue;
            }
            dRemainingDistFromLastSegment += dDistToNextPoint;
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Lines_to_equispaced_points"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.m_Parameters.addNumericalValue(DISTANCE, Sextante.getText((String)"Distance_between_points"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Points"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

