/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.perturbatePointsLayer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class PerturbatePointsLayerAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String MEAN = "MEAN";
    public static final String STDDEV = "STDDEV";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private IVectorLayer m_Output;
    private double m_dMean;
    private double m_dStdDev;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Perturbate_points_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Points_layer"), 0, true);
            this.m_Parameters.addNumericalValue(MEAN, Sextante.getText((String)"Mean"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Standard_deviation"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_dMean = this.m_Parameters.getParameterValueAsDouble(MEAN);
        this.m_dStdDev = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_Layer.getName(), this.m_Layer.getShapeType(), this.m_Layer.getFieldTypes(), this.m_Layer.getFieldNames());
        int i = 0;
        int iShapeCount = this.m_Layer.getShapesCount();
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            this.addPoint(coord.x, coord.y, feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void addPoint(double x, double y, Object[] values) {
        Point pt = this.getAlteredPoint(x, y);
        this.m_Output.addFeature((Geometry)pt, values);
    }

    private Point getAlteredPoint(double x, double y) {
        GeometryFactory gf = new GeometryFactory();
        double dDist = this.getDist();
        double dAngle = Math.random() * Math.PI * 2.0;
        return gf.createPoint(new Coordinate(x + Math.cos(dAngle) * dDist, y + Math.sin(dAngle) * dDist));
    }

    double getDist() {
        double x2;
        double x1;
        double w;
        while ((w = (x1 = 2.0 * Math.random() - 1.0) * x1 + (x2 = 2.0 * Math.random() - 1.0) * x2) >= 1.0) {
        }
        w = Math.sqrt(-2.0 * Math.log(w) / w);
        double y1 = x1 * w;
        return this.m_dMean + this.m_dStdDev * y1;
    }
}

