/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.pointsToLine;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class PointsToLineAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Points_to_line"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Points"), 0, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Line"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_Layer.getName(), 1, this.m_Layer.getFieldTypes(), this.m_Layer.getFieldNames());
        ArrayList<Coordinate> array = new ArrayList<Coordinate>();
        GeometryFactory gf = new GeometryFactory();
        int iShapeCount = this.m_Layer.getShapesCount();
        if (iShapeCount < 2) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Cannot_construct_line_with_less_than_2_points"));
        }
        IFeatureIterator iter = this.m_Layer.iterator();
        IFeature feature = iter.next();
        Geometry geom = feature.getGeometry();
        for (int j = 0; j < geom.getNumGeometries(); ++j) {
            Geometry subgeom = geom.getGeometryN(j);
            Coordinate coord = subgeom.getCoordinate();
            array.add(coord);
        }
        Object[] values = feature.getRecord().getValues();
        int i = 1;
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            feature = iter.next();
            geom = feature.getGeometry();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subgeom = geom.getGeometryN(j);
                Coordinate coord = subgeom.getCoordinate();
                array.add(coord);
            }
            ++i;
        }
        this.m_Output.addFeature((Geometry)gf.createLineString(array.toArray(new Coordinate[0])), values);
        return !this.m_Task.isCanceled();
    }
}

