/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.randomVector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Random;
import java.util.TreeSet;

public class RandomGeometryUtilities {
    private static final Random RAND = new Random();
    private static final GeometryFactory gf = new GeometryFactory();
    private final int maxNodesPerLineMinus3;
    private final int maxHolesPerPolygon;
    private final boolean is3D;

    public RandomGeometryUtilities() {
        this(12, 4, false);
    }

    public RandomGeometryUtilities(int maxNodesPerLineMinus3, int maxHolesPerPolygon, boolean is3D) {
        this.maxNodesPerLineMinus3 = maxNodesPerLineMinus3;
        this.maxHolesPerPolygon = maxHolesPerPolygon;
        this.is3D = is3D;
    }

    private int getNumberOfNodesPerLine() {
        return RAND.nextInt(this.maxNodesPerLineMinus3) + 3;
    }

    private int getNumberOfHolesPerPolygon() {
        return RAND.nextInt(this.maxHolesPerPolygon);
    }

    private Coordinate nextCoordinate() {
        if (this.is3D) {
            return new Coordinate((double)RAND.nextLong(), (double)RAND.nextLong(), (double)RAND.nextLong());
        }
        return new Coordinate((double)RAND.nextLong(), (double)RAND.nextLong(), Double.NaN);
    }

    private Coordinate nextCoordinate(Envelope envelope) {
        if (this.is3D) {
            return new Coordinate((double)RAND.nextInt((int)envelope.getWidth()) + envelope.getMinX(), (double)RAND.nextInt((int)envelope.getHeight()) + envelope.getMinY(), (double)RAND.nextLong());
        }
        try {
            return new Coordinate((double)RAND.nextInt((int)envelope.getWidth()) + envelope.getMinX(), (double)RAND.nextInt((int)envelope.getHeight()) + envelope.getMinY(), Double.NaN);
        }
        catch (Exception ex) {
            double x = RAND.nextDouble() * envelope.getWidth() + envelope.getMinX();
            double y = RAND.nextDouble() * envelope.getHeight() + envelope.getMinY();
            return new Coordinate(x, y, Double.NaN);
        }
    }

    public Coordinate[] nextCoordinates(int n) {
        Coordinate[] result = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextCoordinate();
        }
        return result;
    }

    public Point nextPoint() {
        return gf.createPoint(this.nextCoordinate());
    }

    public Point nextPoint(Envelope envelope) {
        return gf.createPoint(this.nextCoordinate(envelope));
    }

    public Point[] nextPoints(int n) {
        Point[] result = new Point[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextPoint();
        }
        return result;
    }

    public LineSegment nextLineSegment() {
        return new LineSegment(this.nextCoordinate(), this.nextCoordinate());
    }

    public LineSegment[] nextLineSegments(int n) {
        LineSegment[] result = new LineSegment[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextLineSegment();
        }
        return result;
    }

    public LineString nextLineString() {
        int n = this.getNumberOfNodesPerLine();
        TreeSet<Coordinate> nodes = new TreeSet<Coordinate>();
        while (n > nodes.size()) {
            nodes.add(this.nextCoordinate());
        }
        return gf.createLineString(nodes.toArray(new Coordinate[0]));
    }

    public LineString nextLineString(Envelope envelope) {
        int n = this.getNumberOfNodesPerLine();
        TreeSet<Coordinate> nodes = new TreeSet<Coordinate>();
        while (n > nodes.size()) {
            nodes.add(this.nextCoordinate(envelope));
        }
        return gf.createLineString(nodes.toArray(new Coordinate[0]));
    }

    public LineString[] nextLineStrings(int n) {
        LineString[] result = new LineString[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextLineString();
        }
        return result;
    }

    public LinearRing nextLinearRing() {
        CoordinateList cl;
        LinearRing result;
        do {
            cl = new CoordinateList(this.nextLineString().getCoordinates());
            cl.closeRing();
        } while (!(result = gf.createLinearRing(cl.toCoordinateArray())).isValid());
        return result;
    }

    public LinearRing nextLinearRing(Envelope envelope) {
        CoordinateList cl;
        LinearRing result;
        do {
            cl = new CoordinateList(this.nextLineString(envelope).getCoordinates());
            cl.closeRing();
        } while (!(result = gf.createLinearRing(cl.toCoordinateArray())).isValid());
        return result;
    }

    public LinearRing[] nextLinearRings(int n) {
        LinearRing[] result = new LinearRing[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextLinearRing();
        }
        return result;
    }

    public Polygon nextNoHolePolygon() {
        return gf.createPolygon(this.nextLinearRing(), null);
    }

    public Polygon nextNoHolePolygon(Envelope envelope) {
        return gf.createPolygon(this.nextLinearRing(envelope), null);
    }

    public Polygon[] nextNoHolePolygons(int n) {
        Polygon[] result = new Polygon[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextNoHolePolygon();
        }
        return result;
    }

    public Polygon nextPolygon() {
        LinearRing shell = this.nextLinearRing();
        boolean nbHoles = true;
        LinearRing[] holes = new LinearRing[1];
        for (int i = 0; i < 1; ++i) {
            do {
                holes[i] = this.nextLinearRing(shell.getEnvelopeInternal());
            } while (!shell.contains((Geometry)holes[i]));
        }
        return gf.createPolygon(shell, holes);
    }

    public Geometry nextGeometry() {
        switch (RAND.nextInt(4)) {
            case 0: {
                return this.nextPoint();
            }
            case 1: {
                return this.nextLineString();
            }
            case 2: {
                return this.nextLinearRing();
            }
            case 3: {
                return this.nextNoHolePolygon();
            }
        }
        throw new RuntimeException("Unreachable code");
    }

    public Geometry nextGeometry(Envelope env) {
        switch (RAND.nextInt(4)) {
            case 0: {
                return this.nextPoint(env);
            }
            case 1: {
                return this.nextLineString(env);
            }
            case 2: {
                return this.nextLinearRing(env);
            }
            case 3: {
                return this.nextNoHolePolygon(env);
            }
        }
        throw new RuntimeException("Unreachable code");
    }

    public Geometry[] nextGeometries(int n) {
        Geometry[] result = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextGeometry();
        }
        return result;
    }
}

