/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.smoothLines;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.smoothLines.BSpline;
import es.unex.sextante.vectorTools.smoothLines.Bezier;
import es.unex.sextante.vectorTools.smoothLines.ControlCurve;
import es.unex.sextante.vectorTools.smoothLines.NatCubic;
import java.util.ArrayList;

public class SmoothLinesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String INTERMEDIATE_POINTS = "INTERMEDIATE_POINTS";
    public static final String LAYER = "LAYER";
    public static final String CURVE_TYPE = "CURVE_TYPE";
    public static final int NATURAL_CUBIC_SPLINES = 0;
    public static final int BEZIER_CURVES = 1;
    public static final int BSPLINES = 2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        int iSteps = this.m_Parameters.getParameterValueAsInt(INTERMEDIATE_POINTS) + 1;
        int iMethod = this.m_Parameters.getParameterValueAsInt(CURVE_TYPE);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        iSteps = Math.max(1, Math.min(iSteps, 10));
        IVectorLayer output = this.getNewVectorLayer(RESULT, layerIn.getName() + "[" + Sextante.getText((String)"smoothed") + "]", 1, layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int i = 0;
        int iCount = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry simpleGeom = this.getSmoothedLine(feature.getGeometry(), iSteps, iMethod);
            output.addFeature(simpleGeom, feature.getRecord().getValues());
            ++i;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Smooth_lines"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Lines"), 1, true);
            this.m_Parameters.addSelection(INTERMEDIATE_POINTS, Sextante.getText((String)"Intermediate_points"), new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"});
            this.m_Parameters.addSelection(CURVE_TYPE, Sextante.getText((String)"Curve_type"), new String[]{"Natural cubic splines", "Bezier curves", "B splines"});
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Smoothed_lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private Geometry getSmoothedLine(Geometry geometry, int iSteps, int iMethod) {
        ArrayList<LineString> geoms = new ArrayList<LineString>();
        ControlCurve curve = null;
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            switch (iMethod) {
                case 0: {
                    curve = new NatCubic(geometry.getGeometryN(i));
                    break;
                }
                case 1: {
                    curve = new Bezier(geometry.getGeometryN(i));
                    break;
                }
                default: {
                    curve = new BSpline(geometry.getGeometryN(i));
                }
            }
            geoms.add(curve.getSmoothedLine(iSteps));
        }
        GeometryFactory gf = geometry.getFactory();
        return gf.createMultiLineString(geoms.toArray(new LineString[0]));
    }
}

