/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.snapPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.snapPoints.NearestNeighbourFinder;
import java.util.List;

public class SnapPointsAlgorithm
extends GeoAlgorithm {
    public static final String SNAPTO = "SNAPTO";
    public static final String LAYER = "LAYER";
    public static final String TOLERANCE = "TOLERANCE";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private IVectorLayer m_SnapTo;
    private IVectorLayer m_Output;
    private double m_dTolerance;
    private NearestNeighbourFinder m_NNF;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Snap_points_to_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Points_layer"), 0, true);
            this.m_Parameters.addInputVectorLayer(SNAPTO, Sextante.getText((String)"Capa_ajuste"), -1, true);
            this.m_Parameters.addNumericalValue(TOLERANCE, Sextante.getText((String)"Tolerance"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Snapped_points"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_SnapTo = this.m_Parameters.getParameterValueAsVectorLayer(SNAPTO);
        this.m_dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_SnapTo.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_NNF = new NearestNeighbourFinder(this.m_SnapTo, this.m_Task);
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Snapped_points"), this.m_Layer.getShapeType(), this.m_Layer.getFieldTypes(), this.m_Layer.getFieldNames());
        int i = 0;
        int iShapeCount = this.m_Layer.getShapesCount();
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            this.addPoint(coord.x, coord.y, feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void addPoint(double x, double y, Object[] values) {
        Point pt = this.getSnappedPoint(x, y);
        this.m_Output.addFeature((Geometry)pt, values);
    }

    private Point getSnappedPoint(double x, double y) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate c = new Coordinate(x, y);
        Coordinate closestPoint = new Coordinate(x, y);
        double minDist = this.m_dTolerance;
        try {
            List<Geometry> list = this.m_NNF.getClosestGeometries(c, this.m_dTolerance);
            for (int iGeom = 0; iGeom < list.size(); ++iGeom) {
                Geometry geom = list.get(iGeom);
                int iNumGeom = geom.getNumGeometries();
                for (int i = 0; i < iNumGeom; ++i) {
                    Geometry subGeom = geom.getGeometryN(i);
                    Coordinate[] coords = subGeom.getCoordinates();
                    if (coords.length == 1) {
                        double dist = c.distance(coords[0]);
                        if (!(dist < minDist)) continue;
                        minDist = dist;
                        closestPoint = coords[0];
                        continue;
                    }
                    for (int j = 0; j < coords.length - 1; ++j) {
                        LineSegment line = new LineSegment(coords[j], coords[j + 1]);
                        Coordinate closestPointToThisLine = line.closestPoint(c);
                        double dist = c.distance(closestPointToThisLine);
                        if (!(dist < minDist)) continue;
                        minDist = dist;
                        closestPoint = closestPointToThisLine;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gf.createPoint(closestPoint);
    }
}

