/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.union;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.TopologyException;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class UnionAlgorithm
extends GeoAlgorithm {
    public static final String LAYER1 = "LAYER1";
    public static final String LAYER2 = "LAYER2";
    public static final String RESULT = "RESULT";
    private Geometry m_ClipGeometry;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Object[] resultValues;
        Object[] values;
        Geometry g;
        IFeature feature;
        Class fieldType;
        int i;
        IVectorLayer layer1 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER1);
        IVectorLayer layer2 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER2);
        if (!this.m_bIsAutoExtent) {
            layer1.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            layer2.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] fieldTypes = new Class[layer1.getFieldCount() + layer2.getFieldCount()];
        String[] sFieldNames = new String[fieldTypes.length];
        for (i = 0; i < layer1.getFieldCount(); ++i) {
            fieldTypes[i] = fieldType = layer1.getFieldType(i);
            sFieldNames[i] = layer1.getFieldName(i);
        }
        for (i = 0; i < layer2.getFieldCount(); ++i) {
            fieldType = layer2.getFieldType(i);
            int targetIndex = i + layer1.getFieldCount();
            fieldTypes[targetIndex] = fieldType;
            sFieldNames[targetIndex] = this.checkAttrName(layer2.getFieldName(i), targetIndex, sFieldNames);
        }
        IVectorLayer intersection = this.getTempVectorLayer(2, fieldTypes, sFieldNames);
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Union"), 2, fieldTypes, sFieldNames);
        this.setProgressText(Sextante.getText((String)"Intersection") + "(1/4)");
        IFeatureIterator iter = layer1.iterator();
        int i2 = 0;
        int iShapeCount = layer1.getShapesCount();
        while (iter.hasNext() && this.setProgress(i2, iShapeCount)) {
            feature = iter.next();
            Object[] values2 = feature.getRecord().getValues();
            Geometry g2 = feature.getGeometry();
            IFeatureIterator iter2 = layer2.iterator();
            while (iter2.hasNext()) {
                IFeature feature2 = iter2.next();
                Geometry g22 = feature2.getGeometry();
                if (!g22.intersects(g2)) continue;
                Object[] values22 = feature2.getRecord().getValues();
                Geometry inter = g2.intersection(g22);
                Object[] resultValues2 = new Object[values2.length + values22.length];
                this.initializeDefaultValues(fieldTypes, resultValues2);
                System.arraycopy(values2, 0, resultValues2, 0, values2.length);
                System.arraycopy(values22, 0, resultValues2, values2.length, values22.length);
                intersection.addFeature(inter, resultValues2);
            }
            iter2.close();
            ++i2;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.setProgressText(Sextante.getText((String)"Copying_entities") + "(2/4)");
        try {
            intersection.postProcess();
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
        intersection.open();
        iter = intersection.iterator();
        i2 = 0;
        iShapeCount = intersection.getShapesCount();
        while (iter.hasNext() && this.setProgress(i2, iShapeCount)) {
            feature = iter.next();
            output.addFeature(feature);
        }
        iter.close();
        this.m_ClipGeometry = this.computeJtsClippingPoly(intersection);
        this.setProgressText(Sextante.getText((String)"Copying_entities") + "(3/4)");
        iter = layer1.iterator();
        i2 = 0;
        iShapeCount = layer1.getShapesCount();
        while (iter.hasNext() && this.setProgress(i2, iShapeCount)) {
            feature = iter.next();
            g = this.difference(feature.getGeometry());
            if (g != null && !g.isEmpty()) {
                values = feature.getRecord().getValues();
                resultValues = new Object[output.getFieldCount()];
                this.initializeDefaultValues(fieldTypes, resultValues);
                System.arraycopy(values, 0, resultValues, 0, values.length);
                output.addFeature(g, resultValues);
            }
            ++i2;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.setProgressText(Sextante.getText((String)"Copying_entities") + "(4/4)");
        iter = layer2.iterator();
        i2 = 0;
        iShapeCount = layer1.getShapesCount();
        while (iter.hasNext() && this.setProgress(i2, iShapeCount)) {
            feature = iter.next();
            g = this.difference(feature.getGeometry());
            if (g != null && !g.isEmpty()) {
                values = feature.getRecord().getValues();
                resultValues = new Object[output.getFieldCount()];
                this.initializeDefaultValues(fieldTypes, resultValues);
                System.arraycopy(values, 0, resultValues, resultValues.length - values.length, values.length);
                output.addFeature(g, resultValues);
            }
            ++i2;
        }
        iter.close();
        intersection.close();
        return !this.m_Task.isCanceled();
    }

    public Geometry difference(Geometry g) throws GeoAlgorithmExecutionException {
        block7: {
            if (g == null) {
                return null;
            }
            Geometry env = g.getEnvelope();
            if (env == null || this.m_ClipGeometry == null) {
                return null;
            }
            if (!env.intersects(this.m_ClipGeometry.getEnvelope())) {
                return null;
            }
            if (g.intersects(this.m_ClipGeometry)) {
                try {
                    Geometry newGeom = g.difference(this.m_ClipGeometry);
                    return newGeom;
                }
                catch (TopologyException e) {
                    if (!g.isValid()) {
                        throw new GeoAlgorithmExecutionException("Wrong input geometry");
                    }
                    if (this.m_ClipGeometry.isValid()) break block7;
                    throw new GeoAlgorithmExecutionException("Wrong clipping geometry");
                }
            }
        }
        return null;
    }

    private Geometry computeJtsClippingPoly(IVectorLayer layer) throws IteratorException {
        Geometry geometry = null;
        GeometryFactory geomFact = new GeometryFactory();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry currentGeometry = feature.getGeometry();
            if (geometry == null) {
                geometry = currentGeometry;
                continue;
            }
            Geometry[] geoms = new Geometry[]{geometry, currentGeometry};
            GeometryCollection gc = geomFact.createGeometryCollection(geoms);
            geometry = gc.buffer(0.0);
        }
        iter.close();
        return geometry;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Union"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER1, Sextante.getText((String)"Layer_1"), 2, true);
            this.m_Parameters.addInputVectorLayer(LAYER2, Sextante.getText((String)"Layer_2"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Capa_union"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public Geometry clipGeometry(Geometry g) throws GeoAlgorithmExecutionException {
        block7: {
            if (g == null) {
                return null;
            }
            Geometry env = g.getEnvelope();
            if (env == null) {
                return null;
            }
            if (!env.intersects(this.m_ClipGeometry.getEnvelope())) {
                return null;
            }
            if (g.intersects(this.m_ClipGeometry)) {
                try {
                    Geometry newGeom = g.symDifference(this.m_ClipGeometry);
                    return newGeom;
                }
                catch (TopologyException e) {
                    if (!g.isValid()) {
                        throw new GeoAlgorithmExecutionException("Wrong input geometry");
                    }
                    if (this.m_ClipGeometry.isValid()) break block7;
                    throw new GeoAlgorithmExecutionException("Wrong clipping geometry");
                }
            }
        }
        return null;
    }
}

