/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.variableDistanceBuffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.util.ArrayList;
import java.util.Stack;

public class VariableDistanceBufferAlgorithm
extends GeoAlgorithm {
    public static final byte BUFFER_INSIDE_POLY = 1;
    public static final byte BUFFER_OUTSIDE_POLY = 0;
    public static final byte BUFFER_INSIDE_OUTSIDE_POLY = 2;
    public static final String RESULT = "RESULT";
    public static final String NOTROUNDED = "NOTROUNDED";
    public static final String RINGS = "RINGS";
    public static final String TYPE = "TYPES";
    public static final String FIELD = "FIELD";
    public static final String LAYER = "LAYER";
    private IVectorLayer m_Output;
    private boolean m_bRounded;
    private int m_iRings;
    private int m_iType;
    private int numProcessed = 0;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        String[] sFieldNames;
        Class[] types;
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_bRounded = !this.m_Parameters.getParameterValueAsBoolean(NOTROUNDED);
        this.m_iRings = this.m_Parameters.getParameterValueAsInt(RINGS) + 1;
        this.m_iType = this.m_Parameters.getParameterValueAsInt(TYPE);
        int iFieldCount = layerIn.getFieldCount();
        if (layerIn.getShapeType() != 2) {
            this.m_iType = 0;
        }
        if (this.m_iType == 2) {
            types = new Class[iFieldCount + 3];
            types[0] = Long.class;
            types[1] = Double.class;
            sFieldNames = new String[iFieldCount + 3];
            sFieldNames[0] = "ID";
            sFieldNames[1] = "FROM";
            sFieldNames[1] = "TO";
            for (i = 0; i < iFieldCount; ++i) {
                sFieldNames[i + 3] = this.checkAttrName(layerIn.getFieldName(i), i + 3, sFieldNames);
                types[i + 3] = layerIn.getFieldType(i);
            }
        } else {
            types = new Class[iFieldCount + 2];
            types[0] = Long.class;
            types[1] = Double.class;
            sFieldNames = new String[iFieldCount + 2];
            sFieldNames[0] = "ID";
            sFieldNames[1] = "DIST";
            for (i = 0; i < iFieldCount; ++i) {
                sFieldNames[i + 2] = this.checkAttrName(layerIn.getFieldName(i), i + 2, sFieldNames);
                types[i + 2] = layerIn.getFieldType(i);
            }
        }
        this.m_Output = this.getNewVectorLayer(RESULT, "Buffer", 2, types, sFieldNames);
        i = 0;
        int iTotal = layerIn.getShapesCount();
        IFeatureIterator iter = layerIn.iterator();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            double dDistance;
            IFeature feature = iter.next();
            try {
                Number num = (Number)feature.getRecord().getValue(iField);
                dDistance = num.doubleValue();
            }
            catch (Exception e) {
                continue;
            }
            this.computeBuffer(feature.getGeometry(), dDistance, feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sRings = new String[]{Integer.toString(1), Integer.toString(2), Integer.toString(3)};
        String[] sType = new String[]{Sextante.getText((String)"Outer_buffer"), Sextante.getText((String)"Inner_buffer"), Sextante.getText((String)"Both")};
        this.setName(Sextante.getText((String)"Variable_distance_buffer"));
        this.setGroup(Sextante.getText((String)"Buffers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Distance_field"), LAYER);
            this.m_Parameters.addSelection(TYPE, Sextante.getText((String)"Buffer_type"), sType);
            this.m_Parameters.addSelection(RINGS, Sextante.getText((String)"Number_of_concentric_rings"), sRings);
            this.m_Parameters.addBoolean(NOTROUNDED, Sextante.getText((String)"Do_not_round_resulting_polygons"), false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Buffer"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void computeBuffer(Geometry originalGeometry, double bufferDistance, Object[] record) {
        block14: {
            Geometry previousInteriorRing;
            Geometry previousExteriorRing;
            int cap;
            Geometry inputParam;
            Geometry solution;
            block15: {
                block13: {
                    solution = null;
                    inputParam = originalGeometry;
                    if (originalGeometry.getDimension() != 0) {
                        inputParam = TopologyPreservingSimplifier.simplify((Geometry)originalGeometry, (double)(bufferDistance / 10.0));
                    }
                    cap = 1;
                    if (!this.m_bRounded) {
                        cap = 3;
                    }
                    previousExteriorRing = null;
                    previousInteriorRing = null;
                    if (this.m_iType != 1) break block13;
                    for (int i = this.m_iRings; i >= 1; --i) {
                        double distRing = (double)i * bufferDistance;
                        BufferOp bufOp = new BufferOp(inputParam);
                        bufOp.setEndCapStyle(cap);
                        Geometry newGeometry = bufOp.getResultGeometry(-1.0 * distRing);
                        if (this.verifyNilGeometry(newGeometry)) {
                            return;
                        }
                        solution = previousInteriorRing != null ? newGeometry.difference(previousInteriorRing) : newGeometry;
                        ++this.numProcessed;
                        this.addFeature(solution, distRing, record);
                        previousInteriorRing = newGeometry;
                    }
                    break block14;
                }
                if (this.m_iType != 0) break block15;
                for (int i = 1; i <= this.m_iRings; ++i) {
                    double distRing = (double)i * bufferDistance;
                    BufferOp bufOp = new BufferOp(inputParam);
                    bufOp.setEndCapStyle(cap);
                    Geometry newGeometry = bufOp.getResultGeometry(distRing);
                    solution = previousExteriorRing != null ? newGeometry.difference(previousExteriorRing) : newGeometry;
                    ++this.numProcessed;
                    this.addFeature(solution, distRing, record);
                    previousExteriorRing = newGeometry;
                }
                break block14;
            }
            if (this.m_iType != 2) break block14;
            GeometryFactory geomFact = new GeometryFactory();
            for (int i = 1; i <= this.m_iRings; ++i) {
                double distRing = (double)i * bufferDistance;
                BufferOp bufOp = new BufferOp(inputParam);
                bufOp.setEndCapStyle(cap);
                Geometry out = bufOp.getResultGeometry(distRing);
                Geometry in = bufOp.getResultGeometry(-1.0 * distRing);
                boolean collapsedInterior = this.verifyNilGeometry(in);
                if (previousExteriorRing == null || previousInteriorRing == null) {
                    solution = collapsedInterior ? out : out.difference(in);
                } else if (collapsedInterior) {
                    solution = out.difference(previousExteriorRing);
                } else {
                    Geometry outRing = out.difference(previousExteriorRing);
                    Geometry inRing = previousInteriorRing.difference(in);
                    Geometry[] geomArray = new Geometry[]{outRing, inRing};
                    solution = geomFact.createGeometryCollection(geomArray);
                    ArrayList<Geometry> polygons = new ArrayList<Geometry>();
                    Stack<Geometry> stack = new Stack<Geometry>();
                    stack.push(solution);
                    while (stack.size() != 0) {
                        GeometryCollection geCol = (GeometryCollection)stack.pop();
                        for (int j = 0; j < geCol.getNumGeometries(); ++j) {
                            Geometry geometry = geCol.getGeometryN(j);
                            if (geometry instanceof GeometryCollection) {
                                stack.push(geometry);
                            }
                            if (!(geometry instanceof Polygon)) continue;
                            polygons.add(geometry);
                        }
                    }
                    Polygon[] pols = new Polygon[polygons.size()];
                    polygons.toArray(pols);
                    MultiPolygon newSolution = geomFact.createMultiPolygon(pols);
                    solution = newSolution;
                }
                ++this.numProcessed;
                this.addFeature(solution, -1.0 * distRing, distRing, record);
                previousExteriorRing = out;
                if (collapsedInterior) continue;
                previousInteriorRing = in;
            }
        }
    }

    protected void addFeature(Geometry geom, double distance, Object[] record) {
        Object[] values = new Object[2 + record.length];
        values[0] = new Long(this.numProcessed);
        values[1] = new Double(distance);
        for (int i = 0; i < record.length; ++i) {
            values[i + 2] = record[i];
        }
        this.m_Output.addFeature(geom, values);
    }

    protected void addFeature(Geometry geom, double distanceFrom, double distanceTo, Object[] record) {
        Object[] values = new Object[3 + record.length];
        values[0] = new Long(this.numProcessed);
        values[1] = new Double(distanceFrom);
        values[2] = new Double(distanceTo);
        for (int i = 0; i < record.length; ++i) {
            values[i + 3] = record[i];
        }
        this.m_Output.addFeature(geom, values);
    }

    public boolean verifyNilGeometry(Geometry newGeometry) {
        return newGeometry instanceof GeometryCollection && ((GeometryCollection)newGeometry).getNumGeometries() == 0;
    }
}

