/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorize.vectorizeLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class VectorizeLinesAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 0, -1};
    private static final int[] m_iOffsetY = new int[]{-1, 0, 1, 0};
    private static final int[] m_iOffsetXDiag = new int[]{-1, 1, 1, -1};
    private static final int[] m_iOffsetYDiag = new int[]{-1, -1, 1, 1};
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_Window;
    private IRasterLayer m_Visited;
    private IVectorLayer m_Lines;
    private int m_iNX;
    private int m_iNY;
    private int m_iLine = 1;
    private IRasterLayer m_Visited2;
    private final GeometryFactory m_GeometryFactory = new GeometryFactory();

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Vectorize_raster_layer__lines"));
        this.setGroup(Sextante.getText((String)"Vectorization"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Input_layer"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sFields = new String[1];
        Class[] types = new Class[]{Integer.class};
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Window.setWindowExtent(this.m_AnalysisExtent);
        this.m_Visited = this.getTempRasterLayer(0, this.m_Window.getWindowGridExtent());
        this.m_Visited2 = this.getTempRasterLayer(0, this.m_Window.getWindowGridExtent());
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue) || dValue == 0.0) {
                    this.m_Visited.setCellValue(x, y, 0.0);
                    continue;
                }
                this.m_Visited.setCellValue(x, y, 1.0);
            }
        }
        sFields[0] = "ID";
        this.m_Lines = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, types, sFields);
        this.createLines();
        return !this.m_Task.isCanceled();
    }

    private void createLines() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                byte byValue = this.m_Visited.getCellValueAsByte(x, y);
                if (byValue != 1) continue;
                this.createLine(x, y, this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y));
            }
        }
    }

    private void createLine(int x, int y, Point2D pt2d2) {
        boolean bContinue = false;
        boolean bIsNotNull = false;
        Object[] values = new Object[1];
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(pt2d2.getX(), pt2d2.getY()));
        pt2d2 = this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
        coordinates.add(new Coordinate(pt2d2.getX(), pt2d2.getY()));
        do {
            int i;
            Point pt;
            LineString line;
            Coordinate[] coords;
            this.m_Visited.setCellValue(x, y, 0.0);
            ArrayList cells = this.getSurroundingLineCells(x, y);
            this.m_Visited2.setCellValue(x, y, (double)cells.size());
            if (cells.size() == 0) {
                coords = new Coordinate[coordinates.size()];
                for (int i2 = 0; i2 < coords.length; ++i2) {
                    coords[i2] = (Coordinate)coordinates.get(i2);
                }
                line = this.m_GeometryFactory.createLineString(coords);
                values[0] = new Integer(this.m_iLine++);
                this.m_Lines.addFeature((Geometry)line, values);
                bContinue = false;
                continue;
            }
            if (cells.size() == 1) {
                pt = (Point)cells.get(0);
                pt2d2 = this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(pt.x, pt.y);
                coordinates.add(new Coordinate(pt2d2.getX(), pt2d2.getY()));
                x = pt.x;
                y = pt.y;
                bContinue = true;
                bIsNotNull = true;
                continue;
            }
            if (bIsNotNull) {
                coords = new Coordinate[coordinates.size()];
                for (int i3 = 0; i3 < coords.length; ++i3) {
                    coords[i3] = (Coordinate)coordinates.get(i3);
                }
                line = this.m_GeometryFactory.createLineString(coords);
                values[0] = new Integer(this.m_iLine++);
                this.m_Lines.addFeature((Geometry)line, values);
            }
            for (i = 0; i < cells.size(); ++i) {
                pt = (Point)cells.get(i);
                this.m_Visited.setCellValue(pt.x, pt.y, 0.0);
            }
            for (i = 0; i < cells.size(); ++i) {
                pt = (Point)cells.get(i);
                pt2d2 = this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
                this.createLine(pt.x, pt.y, pt2d2);
            }
        } while (bContinue && !this.m_Task.isCanceled());
    }

    private ArrayList getSurroundingLineCells(int x, int y) {
        int i;
        ArrayList<Point> cells = new ArrayList<Point>();
        boolean[] bBlocked = new boolean[4];
        for (i = 0; i < 4; ++i) {
            if (this.m_Visited.getCellValueAsByte(x + m_iOffsetX[i], y + m_iOffsetY[i]) != 1) continue;
            cells.add(new Point(x + m_iOffsetX[i], y + m_iOffsetY[i]));
            bBlocked[i] = true;
            bBlocked[(i + 1) % 4] = true;
        }
        for (i = 0; i < 4; ++i) {
            if (this.m_Visited.getCellValueAsByte(x + m_iOffsetXDiag[i], y + m_iOffsetYDiag[i]) != 1 || bBlocked[i]) continue;
            cells.add(new Point(x + m_iOffsetXDiag[i], y + m_iOffsetYDiag[i]));
        }
        return cells;
    }
}

