/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vegetationIndices.base;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public abstract class DistanceBasedAlgorithm
extends GeoAlgorithm {
    public static final String LAYERRED = "LAYERRED";
    public static final String BANDRED = "BANDRED";
    public static final String LAYERNIR = "LAYERNIR";
    public static final String BANDNIR = "BANDNIR";
    public static final String SLOPE = "SLOPE";
    public static final String INTERCEPT = "INTERCEPT";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_LayerRed;
    private IRasterLayer m_LayerNIR;
    protected double m_dNoData;
    protected double m_dSlope;
    protected double m_dIntercept;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Vegetation_indices"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYERRED, Sextante.getText((String)"Red_layer"), true);
            this.m_Parameters.addBand(BANDRED, Sextante.getText((String)"Red_band"), LAYERRED);
            this.m_Parameters.addInputRasterLayer(LAYERNIR, Sextante.getText((String)"Near_infrared_layer"), true);
            this.m_Parameters.addBand(BANDNIR, Sextante.getText((String)"Near_infrared_band"), LAYERNIR);
            this.m_Parameters.addNumericalValue(SLOPE, Sextante.getText((String)"Soil_line_slope"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(INTERCEPT, Sextante.getText((String)"Soil_line_intercept"), 2, 0.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_LayerRed = this.m_Parameters.getParameterValueAsRasterLayer(LAYERRED);
        int iBandRed = this.m_Parameters.getParameterValueAsInt(BANDRED);
        this.m_LayerNIR = this.m_Parameters.getParameterValueAsRasterLayer(LAYERNIR);
        int iBandNIR = this.m_Parameters.getParameterValueAsInt(BANDNIR);
        this.m_dIntercept = this.m_Parameters.getParameterValueAsDouble(INTERCEPT);
        this.m_dSlope = this.m_Parameters.getParameterValueAsDouble(SLOPE);
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5);
        AnalysisExtent extent = result.getWindowGridExtent();
        this.m_LayerRed.setWindowExtent(extent);
        this.m_LayerNIR.setWindowExtent(extent);
        this.m_LayerRed.setInterpolationMethod(0);
        this.m_LayerNIR.setInterpolationMethod(0);
        int iNX = this.m_LayerRed.getNX();
        int iNY = this.m_LayerRed.getNY();
        this.m_dNoData = result.getNoDataValue();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dRed = this.m_LayerRed.getCellValueAsDouble(x, y, iBandRed);
                double dNIR = this.m_LayerNIR.getCellValueAsDouble(x, y, iBandNIR);
                if (!this.m_LayerRed.isNoDataValue(dRed) && !this.m_LayerNIR.isNoDataValue(dNIR)) {
                    double dIndex = this.getIndex(dRed, dNIR);
                    result.setCellValue(x, y, dIndex);
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    protected abstract double getIndex(double var1, double var3);
}

