/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vegetationIndices.pviRichardson;

import es.unex.sextante.vegetationIndices.base.DistanceBasedAlgorithm;

public class PVIRichardsonAlgorithm
extends DistanceBasedAlgorithm {
    @Override
    public void defineCharacteristics() {
        super.defineCharacteristics();
        this.setName("PVI(Richardson and Wiegand)");
    }

    @Override
    protected double getIndex(double dRed, double dNIR) {
        double dA1 = this.m_dSlope;
        double dA0 = this.m_dIntercept;
        double dB1 = 1.0 / this.m_dSlope;
        double dB0 = dRed - dB1 * dNIR;
        double dRgg5 = (dB1 * dA0 - dB0 * dA1) / (dB1 - dA1);
        double dRgg7 = (dA0 - dB0) / (dB1 - dA1);
        return Math.sqrt(Math.pow(dRgg5 - dRed, 2.0) + Math.pow(dRgg7 - dNIR, 2.0));
    }
}

