/*
 * Decompiled with CFR 0.152.
 */
package it.falciano.sextante.vectorAddField;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.math.BigDecimal;

public class VectorAddFieldAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String FIELD_NAME = "FIELD_NAME";
    public static final String FIELD_TYPE = "FIELD_TYPE";
    public static final String FIELD_LENGTH = "FIELD_LENGTH";
    public static final String FIELD_PRECISION = "FIELD_PRECISION";
    public static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String RESULT = "RESULT";
    public static final int TYPE_INT = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_STRING = 2;
    public static final double DEFAULT_FIELD_LENGTH = 1.0;
    public static final double DEFAUL_FIELD_PRECISION = 0.0;
    public static final double MIN_FIELD_LENGTH = 1.0;
    public static final double MIN_FIELD_PRECISION = 0.0;
    public static final double MAX_FIELD_LENGTH = 254.0;
    public static final double MAX_FIELD_PRECISION = 20.0;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Add_field"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(INPUT, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addString(FIELD_NAME, Sextante.getText((String)"Field_name"));
            String[] sTypes = new String[]{"Integer", "Double", "String"};
            this.m_Parameters.addSelection(FIELD_TYPE, Sextante.getText((String)"Field_type"), sTypes);
            this.m_Parameters.addNumericalValue(FIELD_LENGTH, Sextante.getText((String)"Field_length"), 1, 1.0, 1.0, 254.0);
            this.m_Parameters.addNumericalValue(FIELD_PRECISION, Sextante.getText((String)"Field_precision_Double_only"), 1, 0.0, 0.0, 20.0);
            this.m_Parameters.addString(DEFAULT_VALUE, Sextante.getText((String)"Default_value"));
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1, INPUT);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String sDefaultValue;
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(INPUT);
        String fieldName = this.m_Parameters.getParameterValueAsString(FIELD_NAME);
        int iFieldType = this.m_Parameters.getParameterValueAsInt(FIELD_TYPE);
        int iFieldLength = this.m_Parameters.getParameterValueAsInt(FIELD_LENGTH);
        int iFieldPrecision = this.m_Parameters.getParameterValueAsInt(FIELD_PRECISION);
        try {
            sDefaultValue = iFieldType == 1 ? this.m_Parameters.getParameterValueAsString(DEFAULT_VALUE).substring(0, iFieldLength + 1) : this.m_Parameters.getParameterValueAsString(DEFAULT_VALUE).substring(0, iFieldLength);
        }
        catch (StringIndexOutOfBoundsException e) {
            sDefaultValue = this.m_Parameters.getParameterValueAsString(DEFAULT_VALUE);
            Sextante.addErrorToLog((Throwable)e);
        }
        Class[] inputFieldTypes = layer.getFieldTypes();
        String[] inputFieldNames = layer.getFieldNames();
        Class[] outputFieldTypes = new Class[inputFieldTypes.length + 1];
        String[] outputFieldNames = new String[inputFieldTypes.length + 1];
        for (int i = 0; i < inputFieldTypes.length; ++i) {
            outputFieldTypes[i] = inputFieldTypes[i];
            outputFieldNames[i] = inputFieldNames[i];
        }
        switch (iFieldType) {
            case 0: {
                outputFieldTypes[inputFieldTypes.length] = Integer.class;
                break;
            }
            case 1: {
                outputFieldTypes[inputFieldTypes.length] = Double.class;
                break;
            }
            case 2: {
                outputFieldTypes[inputFieldTypes.length] = String.class;
                break;
            }
        }
        outputFieldNames[inputFieldTypes.length] = fieldName;
        IVectorLayer output = this.getNewVectorLayer(RESULT, layer.getName(), layer.getShapeType(), outputFieldTypes, outputFieldNames);
        int j = 0;
        int iShapeCount = layer.getShapesCount();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(j, iShapeCount)) {
            IFeature feature = iter.next();
            Object[] inputValues = feature.getRecord().getValues();
            Object[] outputValues = new Object[inputValues.length + 1];
            for (int i = 0; i < inputFieldTypes.length; ++i) {
                outputValues[i] = inputValues[i] == null ? null : inputValues[i];
            }
            if (sDefaultValue.length() == 0) {
                outputValues[inputFieldTypes.length] = iFieldType == 0 || iFieldType == 1 ? Integer.valueOf(0) : "";
            } else {
                try {
                    switch (iFieldType) {
                        case 0: {
                            Integer iDefaultValue = new Integer(Integer.parseInt(sDefaultValue));
                            outputValues[inputFieldTypes.length] = iDefaultValue;
                            break;
                        }
                        case 1: {
                            BigDecimal roundDefaultValue = new BigDecimal(Double.parseDouble(sDefaultValue)).setScale(iFieldPrecision, 6);
                            Double dDefaultValue = new Double(roundDefaultValue.doubleValue());
                            outputValues[inputFieldTypes.length] = dDefaultValue;
                            break;
                        }
                        case 2: {
                            outputValues[inputFieldTypes.length] = sDefaultValue;
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
            Geometry geom = feature.getGeometry();
            output.addFeature(geom, outputValues);
            ++j;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

