/*
 * Decompiled with CFR 0.152.
 */
package it.falciano.sextante.vectorRenameField;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class VectorRenameFieldAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String FIELD_TO_RENAME = "FIELD_TO_RENAME";
    public static final String NEW_FIELD_NAME = "NEW_FIELD_NAME";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Rename_field"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(INPUT, Sextante.getText((String)"Vector layer"), -1, true);
            this.m_Parameters.addTableField(FIELD_TO_RENAME, Sextante.getText((String)"field_to_rename"), INPUT);
            this.m_Parameters.addString(NEW_FIELD_NAME, Sextante.getText((String)"name_for_new_field"), "");
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1, INPUT);
        }
        catch (RepeatedParameterNameException e) {
            e.printStackTrace();
        }
        catch (UndefinedParentParameterNameException e) {
            e.printStackTrace();
        }
        catch (OptionalParentParameterException e) {
            e.printStackTrace();
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(INPUT);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD_TO_RENAME);
        String sNewFieldName = this.m_Parameters.getParameterValueAsString(NEW_FIELD_NAME);
        if (sNewFieldName.length() == 0) {
            String s = Sextante.getText((String)"New_field_name_is_empty_Processing_aborted!");
            Sextante.addErrorToLog((String)s);
            throw new GeoAlgorithmExecutionException(s);
        }
        if (sNewFieldName.length() > 10) {
            String s = Sextante.getText((String)"The_length_of_new_field_name_is_over_10_characters_Processing_aborted!");
            Sextante.addErrorToLog((String)s);
            throw new GeoAlgorithmExecutionException(s);
        }
        Class[] inputFieldTypes = layer.getFieldTypes();
        String[] inputFieldNames = layer.getFieldNames();
        Class[] outputFieldTypes = new Class[inputFieldTypes.length];
        String[] outputFieldNames = new String[inputFieldTypes.length];
        for (int i = 0; i < inputFieldTypes.length; ++i) {
            outputFieldTypes[i] = inputFieldTypes[i];
            outputFieldNames[i] = i != iField ? inputFieldNames[i] : sNewFieldName;
        }
        IVectorLayer output = this.getNewVectorLayer(RESULT, layer.getName(), layer.getShapeType(), outputFieldTypes, outputFieldNames);
        boolean j = false;
        int iShapeCount = layer.getShapesCount();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(0, iShapeCount)) {
            IFeature feature = iter.next();
            Object[] inputValues = feature.getRecord().getValues();
            Object[] outputValues = new Object[inputValues.length];
            for (int i = 0; i < inputFieldTypes.length; ++i) {
                outputValues[i] = inputValues[i];
            }
            Geometry geom = feature.getGeometry();
            output.addFeature(geom, outputValues);
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

