/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;

public class URLConnectionHttpClient
implements Twitter.IHttpClient {
    private final String name;
    private final String password;
    private boolean retryingFlag;
    private boolean retryOnError;
    private static final int dfltTimeOutMilliSecs = 10000;
    private int timeout = 10000;

    public URLConnectionHttpClient(String name, String password) {
        this.name = name;
        this.password = password;
        assert (name != null && password != null || name == null && password == null);
    }

    public URLConnectionHttpClient() {
        this(null, null);
    }

    @Override
    public boolean canAuthenticate() {
        return this.name != null && this.password != null;
    }

    public void setTimeout(int millisecs) {
        this.timeout = millisecs;
    }

    @Override
    public String getPage(String uri, Map<String, String> vars, boolean authenticate) throws TwitterException {
        Object inStream;
        assert (uri != null);
        if (vars != null && vars.size() != 0) {
            uri = uri + "?";
            for (Map.Entry<String, String> e : vars.entrySet()) {
                if (e.getValue() == null) continue;
                uri = uri + URLConnectionHttpClient.encode(e.getKey()) + "=" + URLConnectionHttpClient.encode(e.getValue()) + "&";
            }
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(uri).openConnection();
            if (authenticate) {
                this.setBasicAuthentication(connection, this.name, this.password);
            }
            connection.setRequestProperty("User-Agent", "JTwitter/1.4.4");
            connection.setDoInput(true);
            connection.setReadTimeout(this.timeout);
            this.processError(connection);
            inStream = connection.getInputStream();
            String page = URLConnectionHttpClient.toString((InputStream)inStream);
            return page;
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
        catch (TwitterException.E50X e) {
            if (!this.retryOnError || this.retryingFlag) {
                throw e;
            }
            try {
                this.retryingFlag = true;
                Thread.sleep(1000L);
                inStream = this.getPage(uri, vars, authenticate);
                return inStream;
            }
            catch (InterruptedException ex) {
                throw new TwitterException(ex);
            }
            finally {
                this.retryingFlag = false;
            }
        }
    }

    void processError(HttpURLConnection connection) {
        try {
            int code = connection.getResponseCode();
            if (code == 200) {
                return;
            }
            URL url = connection.getURL();
            String error = connection.getResponseMessage();
            if (code == 401) {
                throw new TwitterException.E401(error + " " + url + " (" + (this.name == null ? "anonymous" : this.name) + ")");
            }
            if (code == 403) {
                throw new TwitterException.E403(error + " " + url + " (" + (this.name == null ? "anonymous" : this.name) + ")");
            }
            if (code == 404) {
                throw new TwitterException.E404(error + " " + url);
            }
            if (code >= 500 && code < 600) {
                throw new TwitterException.E50X(error + " " + url);
            }
            boolean rateLimitExceeded = error.contains("Rate limit exceeded");
            if (rateLimitExceeded) {
                throw new TwitterException.RateLimit(error);
            }
            if (code == 400) {
                String json = this.getPage("http://twitter.com/account/rate_limit_status.json", null, this.password != null);
                try {
                    JSONObject obj = new JSONObject(json);
                    int hits = obj.getInt("remaining_hits");
                    if (hits < 1) {
                        throw new TwitterException.RateLimit(error);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            throw new TwitterException(code + " " + error + " " + url);
        }
        catch (SocketTimeoutException e) {
            URL url = connection.getURL();
            throw new TwitterException.Timeout(this.timeout + "milli-secs for " + url);
        }
        catch (ConnectException e) {
            URL url = connection.getURL();
            throw new TwitterException.Timeout(url.toString());
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    private String getErrorStream(HttpURLConnection connection) {
        try {
            return URLConnectionHttpClient.toString(connection.getErrorStream());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ", password=" + (this.password == null ? "null" : "XXX") + "]";
    }

    private void setBasicAuthentication(URLConnection connection, String name, String password) {
        assert (name != null && password != null) : "Authentication requested but no login details are set!";
        String token = name + ":" + password;
        String encoding = new Base64().encodeToString(token.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encoding);
    }

    @Override
    public String post(String uri, Map<String, String> vars, boolean authenticate) throws TwitterException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(uri).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setReadTimeout(this.timeout);
            if (authenticate) {
                this.setBasicAuthentication(connection, this.name, this.password);
            }
            StringBuilder encodedData = new StringBuilder();
            if (vars != null) {
                for (String key : vars.keySet()) {
                    String val = URLConnectionHttpClient.encode(vars.get(key));
                    encodedData.append(URLConnectionHttpClient.encode(key));
                    encodedData.append('=');
                    encodedData.append(val);
                    encodedData.append('&');
                }
            }
            connection.setRequestProperty("Content-Length", "" + encodedData.length());
            OutputStream os = connection.getOutputStream();
            os.write(encodedData.toString().getBytes());
            URLConnectionHttpClient.close(os);
            this.processError(connection);
            String response = URLConnectionHttpClient.toString(connection.getInputStream());
            return response;
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
        catch (TwitterException.E50X e) {
            if (!this.retryOnError || this.retryingFlag) {
                throw e;
            }
            try {
                Thread.sleep(1000L);
                this.retryingFlag = true;
                String os = this.post(uri, vars, authenticate);
                return os;
            }
            catch (InterruptedException ex) {
                throw new TwitterException(ex);
            }
            finally {
                this.retryingFlag = false;
            }
        }
    }

    public void setRetryOnError(boolean retryOnError) {
        this.retryOnError = retryOnError;
    }

    private static String encode(Object x) {
        return URLEncoder.encode(String.valueOf(x));
    }

    private static String toString(InputStream inputStream) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            reader = new InputStreamReader(inputStream);
        }
        return URLConnectionHttpClient.toString(reader);
    }

    private static String toString(Reader reader) throws RuntimeException {
        try {
            int c;
            reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            StringBuilder output = new StringBuilder();
            while ((c = reader.read()) != -1) {
                output.append((char)c);
            }
            String string = output.toString();
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            URLConnectionHttpClient.close(reader);
        }
    }

    private static void close(Closeable input) {
        if (input == null) {
            return;
        }
        try {
            Method m = input.getClass().getMethod("flush", new Class[0]);
            m.invoke((Object)input, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

