/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.execution;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.tools.task.SimpleTaskStatus;

public class PackagesCache
implements Iterable<PackageInfo> {
    private List<CacheEntry> cacheEntries = null;
    private Map<PackageInfo, CacheEntry> package2cacheEntry = null;
    private InstallPackageProviderServices installerProviderServices;

    public PackagesCache(InstallPackageProviderServices installerProviderServices) {
        this.installerProviderServices = installerProviderServices;
        this.package2cacheEntry = new HashMap<PackageInfo, CacheEntry>();
        this.cacheEntries = new ArrayList<CacheEntry>();
    }

    public void addPackage(PackageInfo pkg, File f) {
        PackageCacheEntry cacheEntry = new PackageCacheEntry(pkg, f);
        this.cacheEntries.add(cacheEntry);
        this.package2cacheEntry.put(pkg, cacheEntry);
    }

    public void addPackageIndex(PackageInfo pkg) {
        IndexCacheEntry cacheEntry = new IndexCacheEntry(pkg);
        this.cacheEntries.add(cacheEntry);
        this.package2cacheEntry.put(pkg, cacheEntry);
    }

    public void addBundledPackage(PackageInfo pkg, File bundleFile, String bundleEntryName) {
        BundledPackageCacheEntry cacheEntry = new BundledPackageCacheEntry(pkg, bundleFile, bundleEntryName);
        this.cacheEntries.add(cacheEntry);
        this.package2cacheEntry.put(pkg, cacheEntry);
    }

    public void addBundledPackageIndex(PackageInfo pkg, File bundleFile, String bundleEntryName) {
        BundledIndexCacheEntry cacheEntry = new BundledIndexCacheEntry(pkg, bundleFile, bundleEntryName);
        this.cacheEntries.add(cacheEntry);
        this.package2cacheEntry.put(pkg, cacheEntry);
    }

    public File getFile(PackageInfo packageInfo) {
        CacheEntry entry = this.package2cacheEntry.get(packageInfo);
        return entry.getFile();
    }

    public boolean contains(PackageInfo packageInfo) {
        return this.package2cacheEntry.containsKey(packageInfo);
    }

    public boolean isDownloaded(PackageInfo packageInfo) {
        CacheEntry entry = this.package2cacheEntry.get(packageInfo);
        return entry.isDownloaded();
    }

    public void download(PackageInfo packageInfo, SimpleTaskStatus taskStatus) {
        CacheEntry entry = this.package2cacheEntry.get(packageInfo);
        entry.download(taskStatus);
    }

    public InputStream getInputStream(PackageInfo packageInfo) {
        CacheEntry entry = this.package2cacheEntry.get(packageInfo);
        return entry.getInputStream();
    }

    @Override
    public Iterator<PackageInfo> iterator() {
        return new Iterator<PackageInfo>(){
            Iterator<CacheEntry> it;
            {
                this.it = PackagesCache.this.cacheEntries.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public PackageInfo next() {
                CacheEntry x = this.it.next();
                return x.getPackage();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.package2cacheEntry.size();
    }

    public PackageInfo get(int n) {
        return this.cacheEntries.get(n).getPackage();
    }

    private class BundledIndexCacheEntry
    extends IndexCacheEntry {
        private final File bundleFile;

        BundledIndexCacheEntry(PackageInfo pkg, File bundleFile, String bundleEntryName) {
            super(pkg);
            this.bundleFile = bundleFile;
        }

        @Override
        public File getFile() {
            return this.bundleFile;
        }
    }

    private class BundledPackageCacheEntry
    implements CacheEntry {
        private final PackageInfo pkg;
        private final File bundleFile;
        private final String bundleEntryName;

        BundledPackageCacheEntry(PackageInfo pkg, File bundleFile, String bundleEntryName) {
            this.pkg = pkg;
            this.bundleFile = bundleFile;
            this.bundleEntryName = bundleEntryName;
        }

        @Override
        public PackageInfo getPackage() {
            return this.pkg;
        }

        @Override
        public File getFile() {
            return this.bundleFile;
        }

        @Override
        public void download(SimpleTaskStatus taskStatus) {
        }

        @Override
        public InputStream getInputStream() {
            InputStream is;
            try {
                FileInputStream fis = new FileInputStream(this.bundleFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                is = PackagesCache.this.installerProviderServices.searchPackage((InputStream)bis, this.bundleEntryName);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't open package of '" + this.pkg.getCode() + "'.", ex);
            }
            return is;
        }

        @Override
        public boolean isDownloaded() {
            return true;
        }
    }

    private class IndexCacheEntry
    implements CacheEntry {
        private final PackageInfo pkg;
        private File file;

        IndexCacheEntry(PackageInfo pkg) {
            this.pkg = pkg;
            this.file = null;
        }

        @Override
        public PackageInfo getPackage() {
            return this.pkg;
        }

        @Override
        public void download(SimpleTaskStatus taskStatus) {
            if (this.file == null) {
                try {
                    this.file = this.pkg.downloadFile(taskStatus);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can't download package of '" + this.pkg.getCode() + "'.", ex);
                }
            }
        }

        @Override
        public File getFile() {
            this.download(null);
            return this.file;
        }

        @Override
        public InputStream getInputStream() {
            BufferedInputStream bis;
            try {
                if (this.file == null) {
                    this.download(null);
                }
                FileInputStream fis = new FileInputStream(this.file);
                bis = new BufferedInputStream(fis);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Can't open package of '" + this.pkg.getCode() + "'.", ex);
            }
            return bis;
        }

        @Override
        public boolean isDownloaded() {
            return this.file != null;
        }
    }

    private class PackageCacheEntry
    implements CacheEntry {
        private final PackageInfo pkg;
        private final File file;

        PackageCacheEntry(PackageInfo pkg, File file) {
            this.pkg = pkg;
            this.file = file;
        }

        @Override
        public PackageInfo getPackage() {
            return this.pkg;
        }

        @Override
        public InputStream getInputStream() {
            BufferedInputStream bis;
            try {
                FileInputStream fis = new FileInputStream(this.file);
                bis = new BufferedInputStream(fis);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Can't open package of '" + this.pkg.getCode() + "'.", ex);
            }
            return bis;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void download(SimpleTaskStatus taskStatus) {
        }

        @Override
        public boolean isDownloaded() {
            return true;
        }
    }

    private static interface CacheEntry {
        public PackageInfo getPackage();

        public InputStream getInputStream();

        public File getFile();

        public void download(SimpleTaskStatus var1);

        public boolean isDownloaded();
    }
}

