/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.impl.DefaultPackageInfo;
import org.gvsig.installer.lib.impl.info.InstallerInfoFileReader;
import org.gvsig.installer.lib.spi.InstallerInfoFileException;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decompress {
    private static final int OPTION_DECOMPRESS = 1;
    private static final int OPTION_READ_INSTALLINFO = 2;
    private static final int OPTION_INSTALL = 3;
    private int option = 0;
    private int BUFFER = 2048;
    private static final Logger logger = LoggerFactory.getLogger(Decompress.class);
    private List<PackageInfo> readedIinstallerInfos = null;
    private File outputDirectory = null;
    private List<PackageInfo> selectedInstallerInfos = null;
    private Map<PackageInfo, String> zipEntriesMap = null;
    private List<String> defaultSelectedPackets = null;
    private Properties properties = new Properties();
    private SimpleTaskStatus taskStatus = null;

    public Decompress() {
    }

    public Decompress(SimpleTaskStatus taskStatus) {
        this();
        this.taskStatus = taskStatus;
    }

    public void decompressPlugins(InputStream is, File outputDirectory) throws InstallPackageServiceException {
        this.option = 1;
        this.outputDirectory = outputDirectory;
        this.decompressFolderOfPlugins(is);
    }

    public void readPackageSetInstallInfos(InputStream is, List<PackageInfo> installerInfos, Map<PackageInfo, String> zipEntriesMap) throws InstallPackageServiceException {
        this.option = 2;
        this.readedIinstallerInfos = installerInfos;
        this.zipEntriesMap = zipEntriesMap;
        this.decompressFolderOfPlugins(is);
    }

    public void readPackageInstallInfo(InputStream is, List<PackageInfo> installerInfos, Map<PackageInfo, String> zipEntriesMap, String name) throws InstallPackageServiceException {
        this.option = 2;
        this.readedIinstallerInfos = installerInfos;
        this.zipEntriesMap = zipEntriesMap;
        this.decompressFolderOfPluginFromPackage(is, name);
    }

    public void decompressPlugin(InputStream is, File outputDirectory) throws InstallPackageServiceException {
        try {
            this.option = 1;
            this.outputDirectory = outputDirectory;
            FileUtils.forceMkdir((File)outputDirectory);
            logger.debug("decompress plugin to '" + outputDirectory.getAbsolutePath() + "'.");
            this.decompressPlugin(is);
        }
        catch (Exception e) {
            logger.warn("Can't decompress plugin in '" + outputDirectory + "'.", (Throwable)e);
            throw new InstallPackageServiceException((Throwable)e);
        }
    }

    public InputStream searchPlugin(InputStream is, String zipEntry) throws InstallPackageServiceException {
        ZipEntry entry = null;
        String name = "";
        try {
            ZipInputStream zipInputStream = new ZipInputStream(is);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                name = entry.getName();
                if (entry.getName().equals(zipEntry)) {
                    return zipInputStream;
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (Exception e) {
            throw new InstallerPluginReadErrorException(e, name);
        }
        return null;
    }

    public void installFromStream(InputStream is, PackageInfo installerInfo) throws InstallPackageServiceException {
        this.option = 3;
        this.selectedInstallerInfos = new ArrayList<PackageInfo>();
        this.selectedInstallerInfos.add(installerInfo);
        this.decompressFolderOfPlugins(is);
    }

    public void installFromStream(InputStream is, List<PackageInfo> installerInfos) throws InstallPackageServiceException {
        this.option = 3;
        this.selectedInstallerInfos = installerInfos;
        this.decompressFolderOfPlugins(is);
    }

    private void decompressFolderOfPlugins(InputStream is) throws InstallPackageServiceException {
        ZipInputStream zipInputStream = new ZipInputStream(is);
        ZipEntry entry = null;
        String name = "";
        try {
            while ((entry = zipInputStream.getNextEntry()) != null) {
                int count;
                ByteArrayOutputStream out;
                byte[] data;
                name = entry.getName();
                if (entry.getName().equals("defaultPackages") || entry.getName().equals("defaultSelection")) {
                    data = new byte[this.BUFFER];
                    out = new ByteArrayOutputStream();
                    while ((count = zipInputStream.read(data, 0, this.BUFFER)) != -1) {
                        out.write(data, 0, count);
                    }
                    String str = out.toString().replace("\r", "");
                    String[] lineas = str.split("\\n");
                    ArrayList<String> defaultPackagesList = new ArrayList<String>();
                    for (int i = 0; i < lineas.length; ++i) {
                        String trim_lineas = lineas[i].trim();
                        if (trim_lineas.startsWith("#") || trim_lineas.startsWith(";")) continue;
                        defaultPackagesList.add(lineas[i]);
                    }
                    this.defaultSelectedPackets = defaultPackagesList;
                    out.flush();
                } else if (entry.getName().equals("packages.properties")) {
                    data = new byte[this.BUFFER];
                    out = new ByteArrayOutputStream();
                    while ((count = zipInputStream.read(data, 0, this.BUFFER)) != -1) {
                        out.write(data, 0, count);
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    this.properties.load(in);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                } else if (this.option != 3) {
                    if (this.option == 1) {
                        logger.info("decompress plugin " + name);
                        this.decompressPlugin(zipInputStream);
                    } else if (this.option == 2) {
                        this.readPlugin(zipInputStream, entry.getName());
                    }
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (Exception e) {
            throw new InstallerPluginReadErrorException(e, name);
        }
    }

    private void decompressFolderOfPluginFromPackage(InputStream is, String name) throws InstallPackageServiceException {
        try {
            if (this.option != 3) {
                if (this.option == 1) {
                    this.decompressPlugin(is);
                } else if (this.option == 2) {
                    this.readPlugin(is, name);
                }
            }
        }
        catch (Exception e) {
            throw new InstallerPluginReadErrorException(e, name);
        }
    }

    private void readPlugin(InputStream is, String zipEntryName) throws ZipException, IOException, InstallerInfoFileException {
        ZipEntry entry = null;
        int installerInfoNumber = this.zipEntriesMap.size();
        String packageInfoName = this.getPackageInfoFileName();
        String unixPackageInfoPath = "/".concat(packageInfoName);
        String windowsPackageInfoPath = "\\".concat(packageInfoName);
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            logger.debug("Extracting: " + entry.getName());
            String name = entry.getName();
            if (name.endsWith(unixPackageInfoPath) || name.endsWith(windowsPackageInfoPath)) {
                PackageInfo installerInfo = this.readInstallInfo(zis);
                this.zipEntriesMap.put(installerInfo, zipEntryName);
                this.readedIinstallerInfos.add(installerInfo);
            }
            zis.closeEntry();
        }
    }

    private void decompressPlugin(InputStream inputStream) throws ZipException, IOException, InstallerInfoFileException {
        ZipArchiveInputStream zis = null;
        ZipArchiveEntry entry = null;
        byte[] data = new byte[this.BUFFER];
        int count = 0;
        int countRootFolders = 0;
        String entryName = "(header)";
        try {
            long readed = 0L;
            if (this.taskStatus != null) {
                this.taskStatus.push();
            }
            zis = new ZipArchiveInputStream(inputStream);
            while ((entry = zis.getNextZipEntry()) != null) {
                File file;
                entryName = FilenameUtils.separatorsToSystem((String)entry.getName());
                if (this.taskStatus != null) {
                    this.taskStatus.message(entryName);
                }
                if ((file = new File(this.outputDirectory, entryName)).exists()) {
                    logger.info("delete " + file.getAbsolutePath());
                    FileUtils.forceDelete((File)file);
                }
                if (entry.isDirectory()) {
                    String s = FilenameUtils.getPathNoEndSeparator((String)entryName);
                    if (!s.contains(File.separator) && ++countRootFolders > 1) {
                        logger.warn("More than one root folder (" + entryName + ") in the package; it may be an error.");
                    }
                    logger.debug("makedirs " + file.getAbsolutePath());
                    if (file.mkdirs()) continue;
                    throw new IOException("Can't create folder '" + file.getAbsolutePath() + "'.");
                }
                this.createParentFolder(file);
                logger.debug("extracting " + file.getAbsolutePath());
                FileOutputStream fos = new FileOutputStream(file);
                while ((count = zis.read(data, 0, this.BUFFER)) != -1) {
                    fos.write(data, 0, count);
                    readed += (long)count;
                    if (this.taskStatus == null) continue;
                    this.taskStatus.setCurValue(readed);
                }
                int perms = entry.getUnixMode();
                fos.flush();
                fos.close();
                this.chmod(file, perms);
            }
            zis.close();
        }
        catch (IOException ex) {
            logger.warn("Problems uncompresing plugin (last entry '" + entryName + "'.", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.warn("Problems uncompresing plugin (last entry '" + entryName + "'.", (Throwable)ex);
            throw ex;
        }
        finally {
            if (this.taskStatus != null) {
                this.taskStatus.pop();
            }
        }
    }

    private void chmod(File file, int posixPermissions) {
        try {
            Path path = file.toPath();
            if (!Files.isSymbolicLink(path) && Files.getFileStore(path).supportsFileAttributeView("posix")) {
                int mode = posixPermissions;
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                if ((mode & 0x100) == 256) {
                    permissions.add(PosixFilePermission.OWNER_READ);
                }
                if ((mode & 0x80) == 128) {
                    permissions.add(PosixFilePermission.OWNER_WRITE);
                }
                if ((mode & 0x40) == 64) {
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                }
                if ((mode & 0x20) == 32) {
                    permissions.add(PosixFilePermission.GROUP_READ);
                }
                if ((mode & 0x10) == 16) {
                    permissions.add(PosixFilePermission.GROUP_WRITE);
                }
                if ((mode & 8) == 8) {
                    permissions.add(PosixFilePermission.GROUP_EXECUTE);
                }
                if ((mode & 4) == 4) {
                    permissions.add(PosixFilePermission.OTHERS_READ);
                }
                if ((mode & 2) == 2) {
                    permissions.add(PosixFilePermission.OTHERS_WRITE);
                }
                if ((mode & 1) == 1) {
                    permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                if (!permissions.isEmpty()) {
                    Files.setPosixFilePermissions(path, permissions);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createParentFolder(File file) {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    public boolean delete(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.delete(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public PackageInfo readInstallerInfo(InputStream is) throws InstallerInfoFileException {
        try {
            return this.readInstallInfo(new ZipInputStream(is));
        }
        catch (IOException e) {
            throw new InstallerInfoFileException("error_reading_installerinfo", (Throwable)e);
        }
    }

    private PackageInfo readInstallInfo(ZipInputStream zipInputStream) throws IOException, InstallerInfoFileException {
        int count;
        byte[] data = new byte[this.BUFFER];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((count = zipInputStream.read(data, 0, this.BUFFER)) != -1) {
            out.write(data, 0, count);
        }
        out.flush();
        DefaultPackageInfo installerInfo = new DefaultPackageInfo();
        InstallerInfoFileReader installerInfoFileReader = new InstallerInfoFileReader();
        installerInfoFileReader.read((PackageInfo)installerInfo, new ByteArrayInputStream(out.toByteArray()));
        if (this.taskStatus != null) {
            this.taskStatus.message(installerInfo.getName());
        }
        return installerInfo;
    }

    private String getPackageInfoFileName() {
        return InstallerProviderLocator.getProviderManager().getPackageInfoFileName();
    }

    public List<String> getDefaultSelectedPackages() {
        return this.defaultSelectedPackets;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public class InstallerPluginReadErrorException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 4505298394252120334L;
        private static final String message = "Error reading the plugin '%(name)s'";
        private static final String KEY = "_Error_reading_the_plugin";

        public InstallerPluginReadErrorException(Exception e, String packageName) {
            super(message, (Throwable)e, KEY, 4505298394252120334L);
            this.setValue("name", packageName);
        }
    }

    public class InstallerPluginReadException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = -6065359474790792680L;
        private static final String message = "Error reading the plugin";
        private static final String KEY = "_Error_reading_the_plugin";

        public InstallerPluginReadException(ServiceException e) {
            super(message, (Throwable)e, KEY, -6065359474790792680L);
        }
    }
}

