/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.LayerList;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.WCSParamsPanel;
import org.gvsig.raster.wcs.io.WCSLayerNode;

public class LayerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static Preferences fPrefs = Preferences.userRoot().node("gvsig.wcs-wizard");
    private JPanel jPanel4 = null;
    private JPanel pnlName = null;
    private LayerList lstCoverages = null;
    private JScrollPane jScrollPane = null;
    private JTextField txtName = null;
    private JCheckBox chkExtendedNames = null;
    private WCSParamsPanel parent = null;

    public LayerPanel() {
        this.init();
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getJPanel4(), gridBagConstraints1);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridy = 0;
        this.add((Component)this.getPnlName(), gridBagConstraints1);
        gridBagConstraints1.gridy = 2;
        this.add((Component)this.getChkExtendedNames(), gridBagConstraints1);
    }

    public void setWCSParamsPanel(WCSParamsPanel parent) {
        this.parent = parent;
    }

    private JCheckBox getChkExtendedNames() {
        if (this.chkExtendedNames == null) {
            this.chkExtendedNames = new JCheckBox();
            this.chkExtendedNames.setText(PluginServices.getText((Object)this, (String)"show_layer_names"));
            this.chkExtendedNames.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b;
                    LayerPanel.this.getLstCoverages().showLayerNames = b = LayerPanel.this.chkExtendedNames.isSelected();
                    LayerPanel.this.getLstCoverages().repaint();
                }
            });
            this.chkExtendedNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fPrefs.putBoolean("show_layer_names", LayerPanel.this.chkExtendedNames.isSelected());
                }
            });
            this.chkExtendedNames.setSelected(fPrefs.getBoolean("show_layer_names", false));
        }
        return this.chkExtendedNames;
    }

    private JPanel getPnlName() {
        if (this.pnlName == null) {
            this.pnlName = new JPanel(new BorderLayout());
            this.pnlName.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"nombre_cobertura"), 0, 0, null, null));
            this.pnlName.add((Component)this.getTxtName(), "Center");
        }
        return this.pnlName;
    }

    public JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    public LayerList getLstCoverages() {
        if (this.lstCoverages == null) {
            this.lstCoverages = new LayerList();
            this.lstCoverages.setSelectionMode(0);
            this.lstCoverages.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    LayerPanel.this.parent.refreshData(null);
                }
            });
        }
        return this.lstCoverages;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)((Object)this.getLstCoverages()));
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel(new BorderLayout());
            this.jPanel4.add((Component)this.getJScrollPane(), "Center");
            this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"seleccionar_coberturas"), 0, 0, null, null));
        }
        return this.jPanel4;
    }

    public int getCoverageIndex(String coverageName) {
        for (int i = 0; i < this.getLstCoverages().getModel().getSize(); ++i) {
            if (!coverageName.equals(((WCSLayerNode)this.getLstCoverages().getModel().getElementAt(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    public String getSelectedInListCoverageName() {
        if (this.getLstCoverages().getSelectedValue() == null) {
            return null;
        }
        return ((WCSLayerNode)this.getLstCoverages().getSelectedValue()).getName();
    }

    public String getSelectedCoverageName() {
        if (this.getTxtName().getText().compareTo("") == 0) {
            return null;
        }
        for (int i = 0; i < this.getLstCoverages().getModel().getSize(); ++i) {
            WCSLayerNode node = (WCSLayerNode)this.getLstCoverages().getModel().getElementAt(i);
            if (node.getTitle().compareTo(this.getTxtName().getText()) != 0) continue;
            return node.getName();
        }
        return null;
    }

    public String getNameByTitle(String title) {
        for (int i = 0; i < this.getLstCoverages().getModel().getSize(); ++i) {
            WCSLayerNode node = (WCSLayerNode)this.getLstCoverages().getModel().getElementAt(i);
            if (node.getTitle().compareTo(title) != 0) continue;
            return node.getName();
        }
        return null;
    }

    public String getTitleByName(String name) {
        for (int i = 0; i < this.getLstCoverages().getModel().getSize(); ++i) {
            WCSLayerNode node = (WCSLayerNode)this.getLstCoverages().getModel().getElementAt(i);
            if (node.getName().compareTo(name) != 0) continue;
            return node.getTitle();
        }
        return null;
    }
}

