/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.mainplugin;

import java.awt.Dimension;
import javax.swing.JToolBar;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.mainplugin.toolbar.GenericToolBarMenuItem;
import org.gvsig.raster.mainplugin.toolbar.GenericToolBarPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class GenericToolBarExtension
extends Extension {
    private GenericToolBarPanel toolBar = null;

    private GenericToolBarPanel getGenericToolBarPanel() {
        if (this.toolBar == null) {
            MDIFrame f = (MDIFrame)PluginServices.getMainFrame();
            if (f == null) {
                return null;
            }
            this.toolBar = new GenericToolBarPanel();
            this.toolBar.setVisible(true);
            f.addToolBarControl(((Object)((Object)this)).getClass(), (JToolBar)this.toolBar, "RasterToolBar");
        } else {
            this.toolBar.setPreferredSize(new Dimension(300, this.getToolbarHeight()));
        }
        return this.toolBar;
    }

    private int getToolbarHeight() {
        if (PluginServices.getMainFrame() == null || PluginServices.getMainFrame().getToolbars() == null || PluginServices.getMainFrame().getToolbars().length <= 0) {
            return 24;
        }
        for (int i = 0; i < PluginServices.getMainFrame().getToolbars().length; ++i) {
            if (PluginServices.getMainFrame().getToolbars()[i].getHeight() <= 16 || PluginServices.getMainFrame().getToolbars()[i] == this.toolBar) continue;
            return PluginServices.getMainFrame().getToolbars()[i].getHeight();
        }
        return 24;
    }

    public void initialize() {
        this.registerIcons();
        Messages.addResourceFamily((String)"org.gvsig.raster.mainplugin.i18n.text", (ClassLoader)GenericToolBarExtension.class.getClassLoader(), (String)GenericToolBarExtension.class.getClass().getName());
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("GenericToolBarGroup");
        point.setDescription("Punto de extension para los grupos de menus del GenericToolBarPanel");
        point.append("RasterLayer", "", (ExtensionBuilder)new GenericToolBarMenuItem(Messages.getText((String)"capa_raster"), IconThemeHelper.getImageIcon((String)"menu-layer-icon")));
        point.append("Dataset", "", (ExtensionBuilder)new GenericToolBarMenuItem(Messages.getText((String)"dataset_raster"), IconThemeHelper.getImageIcon((String)"menu-dataset-icon")));
        point.append("Multispectral", "", (ExtensionBuilder)new GenericToolBarMenuItem(Messages.getText((String)"multispectral"), IconThemeHelper.getImageIcon((String)"menu-multispectral-icon")));
        point.append("Enhanced", "", (ExtensionBuilder)new GenericToolBarMenuItem(Messages.getText((String)"enhanced"), IconThemeHelper.getImageIcon((String)"menu-enhanced-icon")));
        point.append("GeoRaster", "", (ExtensionBuilder)new GenericToolBarMenuItem(Messages.getText((String)"transformaciones_geograficas"), IconThemeHelper.getImageIcon((String)"menu-transgeo-icon")));
        point.append("RasterExport", "", (ExtensionBuilder)new GenericToolBarMenuItem(Messages.getText((String)"raster_export"), IconThemeHelper.getImageIcon((String)"menu-raster-export")));
        point = extensionPoints.add("GenericToolBarMenu");
        point.setDescription("Punto de extension para los submenus del GenericToolBarPanel");
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"menu-layer-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-process-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-transgeo-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-dataset-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-raster-export", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-multispectral-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-enhanced-icon", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
        if (this.getGenericToolBarPanel() != null) {
            this.getGenericToolBarPanel().reloadMenuGroup();
        }
    }

    public boolean isEnabled() {
        return false;
    }

    private void setToolBarVisible(boolean enabled) {
        if (this.getGenericToolBarPanel() == null) {
            return;
        }
        this.toolBar.setVisible(enabled);
    }

    public boolean isVisible() {
        AbstractViewPanel vista;
        ViewDocument model;
        MapContext mapa;
        this.setToolBarVisible(true);
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null || !(f instanceof AbstractViewPanel)) {
            return false;
        }
        if (this.getGenericToolBarPanel() != null) {
            this.getGenericToolBarPanel().setLayers(null);
        }
        if ((mapa = (model = (vista = (AbstractViewPanel)f).getModel()).getMapContext()).getLayers().getLayersCount() > 0 && this.getGenericToolBarPanel() != null) {
            this.getGenericToolBarPanel().setLayers(mapa.getLayers());
        }
        return true;
    }

    public void execute(String actionCommand) {
    }
}

