/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.scriptlets;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;
import net.sf.jasperreports.engine.util.JRClassLoader;

public final class DefaultScriptletFactory
implements ScriptletFactory {
    private static final DefaultScriptletFactory INSTANCE = new DefaultScriptletFactory();
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR = "scriptlets.class.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_INSTANCE_LOADING_ERROR = "scriptlets.instance.loading.error";

    private DefaultScriptletFactory() {
    }

    public static DefaultScriptletFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public List<JRAbstractScriptlet> getScriplets(ScriptletFactoryContext context) throws JRException {
        JRScriptlet[] scriptletsArray;
        String scriptletClassName;
        ArrayList<JRAbstractScriptlet> scriptlets = new ArrayList<JRAbstractScriptlet>();
        JRAbstractScriptlet scriptlet = (JRAbstractScriptlet)context.getParameterValues().get("REPORT_SCRIPTLET");
        if (scriptlet == null && (scriptletClassName = context.getDataset().getScriptletClass()) != null) {
            scriptlet = this.getScriptlet(scriptletClassName);
            context.getParameterValues().put("REPORT_SCRIPTLET", scriptlet);
        }
        if (scriptlet != null) {
            scriptlets.add(scriptlet);
        }
        if ((scriptletsArray = context.getDataset().getScriptlets()) != null) {
            for (int i = 0; i < scriptletsArray.length; ++i) {
                String paramName = scriptletsArray[i].getName() + "_SCRIPTLET";
                scriptlet = (JRAbstractScriptlet)context.getParameterValues().get(paramName);
                if (scriptlet == null) {
                    scriptlet = this.getScriptlet(scriptletsArray[i].getValueClassName());
                    context.getParameterValues().put(paramName, scriptlet);
                }
                scriptlets.add(scriptlet);
            }
        }
        return scriptlets;
    }

    protected JRAbstractScriptlet getScriptlet(String scriptletClassName) throws JRException {
        JRAbstractScriptlet scriptlet = null;
        try {
            Class<?> scriptletClass = JRClassLoader.loadClassForName(scriptletClassName);
            scriptlet = (JRAbstractScriptlet)scriptletClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR, new Object[]{scriptletClassName}, e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INSTANCE_LOADING_ERROR, new Object[]{scriptletClassName}, e);
        }
        return scriptlet;
    }
}

