/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gvsig.gpe.prov.gml.parser.profiles.IBindingProfile;
import org.gvsig.gpe.prov.xml.exceptions.GPEXmlEmptyFileException;
import org.gvsig.gpe.prov.xml.parser.GPEXmlParser;
import org.gvsig.gpe.prov.xml.utils.QNameComparator;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public abstract class GPEDefaultGmlParser
extends GPEXmlParser {
    private IXmlStreamReader fileParser = null;
    private IBindingProfile profile = null;
    protected QNameComparator qNameComparator = null;

    public String[] getFormats() {
        String[] formats = new String[]{"GML", "XML", "BGML"};
        return formats;
    }

    public boolean accept(URI uri) {
        return uri.getPath().toUpperCase().endsWith("GML") || uri.getPath().toUpperCase().endsWith("XML") || uri.getPath().toUpperCase().endsWith("BGML");
    }

    public boolean accept(File file) {
        return file.getPath().toUpperCase().endsWith("GML") || file.getPath().toUpperCase().endsWith("XML") || file.getPath().toUpperCase().endsWith("BGML");
    }

    protected InputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    protected void initParse() throws GPEXmlEmptyFileException, XmlStreamException {
        this.fileParser = this.getParser();
        if (this.getParser().getEventType() == 8) {
            throw new GPEXmlEmptyFileException();
        }
        try {
            this.getProfile().getFeatureCollectionBinding().parse(this.getParser(), this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public IXmlStreamReader getFileParser() {
        return this.fileParser;
    }

    public void getNext() {
        try {
            this.fileParser.next();
            if (this.fileParser.getEventType() == 4 && this.fileParser.isWhitespace()) {
                this.getNext();
            }
        }
        catch (XmlStreamException e) {
            System.out.println("Error en XmlPullParser al intentar obtener la siguiente etiqueta: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Error al leer la siguiente etiqueta en XmlPullParser: " + e.getMessage());
        }
    }

    protected void setProfile(IBindingProfile profile) {
        this.profile = profile;
    }

    public IBindingProfile getProfile() {
        return this.profile;
    }

    public QNameComparator getQNameComparator() {
        return this.qNameComparator;
    }

    public String getProjection() {
        return null;
    }
}

