/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.sfp0.geometries;

import java.io.IOException;
import java.util.StringTokenizer;
import org.gvsig.compat.CompatLocator;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.parser.v2.geometries.DoubleTypeBinding;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class LowerCornerTypeBinding
implements ICoordinateIterator {
    private String TUPLES_SEPARATOR = "[\n\\s\r\t ]+";
    private String COORDINATES_DECIMAL = ".";
    private StringTokenizer coordinatesString = null;
    private int dimension = 0;
    private IXmlStreamReader parser = null;
    private GPEDefaultGmlParser handler;

    public void parse(IXmlStreamReader parser, GPEDefaultGmlParser handler) throws XmlStreamException, IOException {
        boolean endFeature = false;
        this.parser = parser;
        this.handler = handler;
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (!handler.getQNameComparator().equals(tag, GmlTags.GML_LOWERCORNER)) break;
                    parser.next();
                    String coordinatesTag = parser.getText().trim();
                    this.dimension = this.caculateDimension(coordinatesTag);
                    this.coordinatesString = new StringTokenizer(coordinatesTag, this.TUPLES_SEPARATOR);
                    break;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, GmlTags.GML_LOWERCORNER)) break;
                    endFeature = true;
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
    }

    private int caculateDimension(String coordinatesTag) {
        return CompatLocator.getStringUtils().split(coordinatesTag, this.TUPLES_SEPARATOR).length;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean hasNext() throws IOException {
        return this.coordinatesString.hasMoreTokens();
    }

    public void next(double[] buffer) throws IOException {
        String next = this.coordinatesString.nextToken();
        for (int i = 0; i < this.dimension; ++i) {
            buffer[i] = DoubleTypeBinding.parse(next, this.COORDINATES_DECIMAL, this.handler);
            if (!this.coordinatesString.hasMoreTokens()) continue;
            next = this.coordinatesString.nextToken();
        }
        this.parseLowerCorner();
    }

    private void parseLowerCorner() throws XmlStreamException {
        this.parser.next();
        IQName tag = this.parser.getName();
        int currentTag = this.parser.getEventType();
        if (this.handler.getQNameComparator().equals(tag, GmlTags.GML_LOWERCORNER)) {
            this.parser.next();
            String coordinatesTag = this.parser.getText().trim();
            this.coordinatesString = new StringTokenizer(coordinatesTag, this.TUPLES_SEPARATOR);
            boolean endLowerCorner = false;
            while (!endLowerCorner) {
                switch (currentTag) {
                    case 2: {
                        if (!this.handler.getQNameComparator().equals(tag, GmlTags.GML_LOWERCORNER)) break;
                        endLowerCorner = true;
                    }
                }
                if (endLowerCorner) continue;
                currentTag = this.parser.next();
                tag = this.parser.getName();
            }
        }
    }
}

