/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.v2.features;

import java.io.IOException;
import org.gvsig.gpe.lib.api.parser.IAttributesIterator;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.utils.GmlGeometries;
import org.gvsig.gpe.prov.gml.utils.GmlUtilsParser;
import org.gvsig.gpe.prov.xml.utils.XMLAttributesIterator;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;
import org.gvsig.xmlschema.lib.api.som.IXSElementDeclaration;
import org.gvsig.xmlschema.lib.api.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementTypeBinding {
    private static Logger logger = LoggerFactory.getLogger(ElementTypeBinding.class);
    private static long logCount = 0L;

    public Object parse(IXmlStreamReader parser, GPEDefaultGmlParser handler, Object feature, Object parentElement, IXSElementDeclaration parentType) throws XmlStreamException, IOException {
        boolean endFeature = false;
        boolean isGeometryTag = false;
        Object element = null;
        Object value = null;
        Object geometry = null;
        boolean isInitialized = false;
        IQName elementRootType = parser.getName();
        String type = null;
        XMLAttributesIterator attributesIterator = new XMLAttributesIterator(parser);
        IXSElementDeclaration elementType = null;
        type = parentType != null ? ((elementType = parentType.getSubElementByName(elementRootType.getLocalPart())) == null ? TypeUtils.getXSType(String.class) : elementType.getTypeName()) : TypeUtils.getXSType(String.class);
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (handler.getQNameComparator().equals(tag, elementRootType)) break;
                    if (GmlGeometries.isGML(tag)) {
                        geometry = handler.getProfile().getGeometryBinding().parse(parser, handler);
                        if (geometry != null) {
                            handler.getContentHandler().addGeometryToFeature(geometry, feature);
                        } else {
                            if (logCount % 50L == 0L) {
                                logger.info("ERROR. Unable to parse geometry: " + tag.getLocalPart());
                            }
                            ++logCount;
                        }
                        isGeometryTag = true;
                        break;
                    }
                    if (!isInitialized) {
                        element = handler.getContentHandler().startElement(elementRootType.getNamespaceURI(), GmlUtilsParser.removeBlancSymbol(elementRootType.getLocalPart()), null, (IAttributesIterator)attributesIterator, parentElement);
                        isInitialized = true;
                    }
                    handler.getProfile().getElementTypeBinding().parse(parser, handler, feature, element, null);
                    break;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, elementRootType)) break;
                    endFeature = true;
                    if (isGeometryTag) {
                        element = handler.getContentHandler().startElement(elementRootType.getNamespaceURI(), GmlUtilsParser.removeBlancSymbol(elementRootType.getLocalPart()), geometry, (IAttributesIterator)attributesIterator, parentElement);
                    } else if (!isInitialized) {
                        element = handler.getContentHandler().startElement(elementRootType.getNamespaceURI(), GmlUtilsParser.removeBlancSymbol(elementRootType.getLocalPart()), value, (IAttributesIterator)attributesIterator, parentElement);
                        isInitialized = true;
                    }
                    handler.getContentHandler().endElement(element);
                    break;
                }
                case 4: {
                    if (geometry != null) break;
                    value = TypeUtils.getValue((IXSElementDeclaration)elementType, (String)parser.getText());
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
        return element;
    }
}

